/*
 * Decompiled with CFR 0.152.
 */
package de.srsoftware.tools;

import java.util.Base64;
import java.util.UUID;

public class Strings {
    private Strings() {
    }

    public static String base64(byte[] bytes) {
        return Base64.getEncoder().encodeToString(bytes);
    }

    public static String camelCase(String text) {
        if (text == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean upper = false;
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c == ' ') {
                upper = true;
                continue;
            }
            sb.append(upper ? Character.toUpperCase(c) : c);
            upper = false;
        }
        return sb.toString();
    }

    public static String fill(int indent, String text, Object ... fills) {
        StringBuilder sb = new StringBuilder(" ".repeat(indent));
        if (fills == null || fills.length < 1) {
            return sb.append(text).toString();
        }
        String[] parts = text.split("\\{\\}", fills.length + 1);
        for (int i = 0; i < parts.length - 1; ++i) {
            sb.append(parts[i]);
            sb.append(fills[i]);
        }
        sb.append(parts[parts.length - 1]);
        return sb.toString();
    }

    public static String fill(String text, Object ... fills) {
        return Strings.fill(0, text, fills);
    }

    public static String hex(byte[] bytes) {
        StringBuilder sb = new StringBuilder(bytes.length * 2);
        for (byte b : bytes) {
            sb.append(String.format("%02x", b));
        }
        return sb.toString();
    }

    public static String uuid() {
        return UUID.randomUUID().toString();
    }
}

