/*
 * Decompiled with CFR 0.152.
 */
package de.srsoftware.tools;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Optional;

public class Calc {
    private static final System.Logger LOG = System.getLogger(Calc.class.getSimpleName());
    private static final MessageDigest SHA256 = Calc.getSha256();

    private Calc() {
    }

    private static MessageDigest getSha256() {
        try {
            return MessageDigest.getInstance("SHA256");
        }
        catch (NoSuchAlgorithmException e) {
            LOG.log(System.Logger.Level.ERROR, "Failed to get SHA256 digest object! [{0}]", Calc.class.getPackageName());
            System.exit(1);
            return null;
        }
    }

    public static long ggt(long a, long b) {
        if (a == 0L || b == 0L) {
            return 0L;
        }
        while (a != b) {
            if (a > b) {
                a -= b;
                continue;
            }
            b -= a;
        }
        return a;
    }

    public static Optional<byte[]> sha256(Object o) {
        return Optional.ofNullable(o).map(Object::toString).map(s -> s.getBytes(StandardCharsets.UTF_8)).map(SHA256::digest);
    }
}

