/*
 * Decompiled with CFR 0.152.
 */
package de.srsoftware.tools;

import de.srsoftware.tools.Result;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import org.json.JSONObject;

public class Error<None>
implements Result<None> {
    private final List<Exception> exceptions = new ArrayList<Exception>();
    private final Map<String, Object> data = new HashMap<String, Object>();
    private final String message;

    public Error(String message) {
        this.message = message;
    }

    public Error<None> add(Exception exception) {
        this.exceptions.add(exception);
        return this;
    }

    public Error<None> addData(Object ... tokens) {
        for (int i = 0; i < tokens.length - 1; i += 2) {
            this.data.put(tokens[i].toString(), tokens[i + 1]);
        }
        return this;
    }

    public Map<String, Object> data() {
        return this.data;
    }

    public List<Exception> exceptions() {
        return this.exceptions;
    }

    public static <None> Error<None> format(String message, Object ... fills) {
        return new Error<None>(message.formatted(fills));
    }

    public JSONObject json() {
        JSONObject json = new JSONObject(Map.of("error", this.message));
        if (!this.exceptions.isEmpty()) {
            json.put("exceptions", this.exceptions);
        }
        if (!this.data.isEmpty()) {
            json.put("data", this.data);
        }
        return json;
    }

    @Override
    public <Mapped> Result<Mapped> map(Function<Result<None>, Result<Mapped>> mapper) {
        return mapper.apply(this);
    }

    public static <None> Error<None> of(String message, Exception ... exceptions) {
        Error<None> err = new Error<None>(message);
        for (Exception e : exceptions) {
            err.add(e);
        }
        return err;
    }

    @Override
    public Optional<None> optional() {
        return Optional.empty();
    }

    @Override
    public <Inner> Stream<Result<Inner>> stream() {
        return Stream.of(this.transform());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.message);
        for (Exception ex : this.exceptions) {
            sb.append("\n").append(ex.getMessage());
        }
        return sb.toString();
    }

    public <NewType> Error<NewType> transform() {
        Error<None> transformed = Error.of(this.message, new Exception[0]);
        transformed.data.putAll(this.data());
        transformed.exceptions.addAll(this.exceptions);
        return transformed;
    }

    public Optional<Error<None>> wrap() {
        return Optional.of(this);
    }
}

