/*
 * Decompiled with CFR 0.152.
 */
package de.srsoftware.tools;

import java.util.UUID;

public class Strings {
    private Strings() {
    }

    public static String fill(int indent, String text, Object ... fills) {
        StringBuilder sb = new StringBuilder(" ".repeat(indent));
        if (fills == null || fills.length < 1) {
            return sb.append(text).toString();
        }
        String[] parts = text.split("\\{\\}", fills.length + 1);
        for (int i = 0; i < parts.length - 1; ++i) {
            sb.append(parts[i]);
            sb.append(fills[i]);
        }
        sb.append(parts[parts.length - 1]);
        return sb.toString();
    }

    public static String fill(String text, Object ... fills) {
        return Strings.fill(0, text, fills);
    }

    public static String hex(byte[] bytes) {
        StringBuilder sb = new StringBuilder(bytes.length * 2);
        for (byte b : bytes) {
            sb.append(String.format("%02x", b));
        }
        return sb.toString();
    }

    public static String uuid() {
        return UUID.randomUUID().toString();
    }
}

