/*
 * Decompiled with CFR 0.152.
 */
package de.srsoftware.tools;

import de.srsoftware.tools.Error;
import de.srsoftware.tools.Result;
import java.util.Collection;
import java.util.function.Function;
import java.util.stream.Stream;

public class Payload<P>
implements Result<P> {
    private final P object;

    public Payload(P object) {
        this.object = object;
    }

    public static <P> Payload<P> of(P object) {
        return new Payload<P>(object);
    }

    public P get() {
        return this.object;
    }

    @Override
    public <Mapped> Result<Mapped> map(Function<Result<P>, Result<Mapped>> mapper) {
        return mapper.apply(this);
    }

    @Override
    public <Inner> Stream<Result<Inner>> stream() {
        P p = this.object;
        if (p instanceof Collection) {
            Collection coll = (Collection)p;
            try {
                Collection collection = coll;
                return collection.stream().map(Payload::of);
            }
            catch (ClassCastException cce) {
                return Stream.of(Error.of("Failed to cast %s".formatted(coll.getClass().getSimpleName()), cce));
            }
        }
        try {
            P inner = this.object;
            return Stream.of(Payload.of(inner));
        }
        catch (ClassCastException cce) {
            return Stream.of(Error.of("Failed to cast %s".formatted(this.object.getClass().getSimpleName()), cce));
        }
    }

    public String toString() {
        return this.object.toString();
    }
}

