/*
 * Decompiled with CFR 0.152.
 */
package de.srsoftware.tools;

import de.srsoftware.tools.Result;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.json.JSONObject;

public class Error<None>
implements Result<None> {
    private final List<Exception> exceptions = new ArrayList<Exception>();
    private Map<String, Object> data = new HashMap<String, Object>();
    private final String message;

    public Error(String message) {
        this.message = message;
    }

    public Error<None> add(Exception exception) {
        this.exceptions.add(exception);
        return this;
    }

    public Error<None> addData(Object ... tokens) {
        for (int i = 0; i < tokens.length - 1; i += 2) {
            this.data.put(tokens[i].toString(), tokens[i + 1]);
        }
        return this;
    }

    public Map<String, Object> data() {
        return this.data;
    }

    public List<Exception> exceptions() {
        return this.exceptions;
    }

    public static <None> Error<None> format(String message, Object ... fills) {
        return new Error<None>(message.formatted(fills));
    }

    public JSONObject json() {
        JSONObject json = new JSONObject(Map.of("error", this.message));
        if (!this.exceptions.isEmpty()) {
            json.put("exceptions", this.exceptions);
        }
        if (!this.data.isEmpty()) {
            json.put("data", this.data);
        }
        return json;
    }

    public static <None> Error<None> of(String message) {
        return new Error<None>(message);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.message);
        for (Exception ex : this.exceptions) {
            sb.append("\n").append(ex.getMessage());
        }
        return sb.toString();
    }

    public Optional<Error<None>> wrap() {
        return Optional.of(this);
    }
}

