/*
 * Decompiled with CFR 0.152.
 */
package de.srsoftware.tools;

import de.srsoftware.tools.Result;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;

public class Error<T>
implements Result<T> {
    private final String cause;
    private Map<String, Object> metadata;

    public Error(String cause) {
        this.cause = cause;
    }

    public String cause() {
        return this.cause;
    }

    @Override
    public boolean isError() {
        return true;
    }

    public static <T> Error<T> message(String cause, Object ... tokens) {
        Error<T> err = new Error<T>(cause);
        err.metadata = new HashMap<String, Object>();
        for (int i = 0; i < tokens.length - 1; i += 2) {
            err.metadata.put(tokens[i].toString(), tokens[i + 1]);
        }
        return err;
    }

    public JSONObject json() {
        JSONObject json = new JSONObject(Map.of("error", this.cause));
        if (this.metadata != null) {
            json.put("metadata", this.metadata);
        }
        return json;
    }
}

