/*
 * Decompiled with CFR 0.152.
 */
package de.srsoftware.tools;

import java.util.Collection;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.Vector;

public class PrefixTree
implements Collection<String> {
    private TreeMap<Character, PrefixTree> collection = new TreeMap();
    private int size = -1;
    private boolean ignoreCase = true;

    public PrefixTree() {
        this(false);
    }

    public PrefixTree(boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
    }

    @Override
    public boolean add(String s) {
        if (s == null) {
            return false;
        }
        if ((s = s.trim()).length() < 1) {
            return false;
        }
        return this.internAdd(s);
    }

    @Override
    public boolean addAll(Collection<? extends String> strings) {
        for (String string : strings) {
            if (this.internAdd(string)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void clear() {
        this.collection.clear();
        this.size = -1;
    }

    @Override
    public boolean contains(Object o) {
        char c;
        PrefixTree subtree;
        if (o == null) {
            return false;
        }
        String s = o.toString();
        if (s.length() < 1) {
            return true;
        }
        if (this.ignoreCase) {
            s = s.toLowerCase();
        }
        if ((subtree = this.collection.get(Character.valueOf(c = s.charAt(0)))) == null) {
            return false;
        }
        return subtree.contains(s.substring(1));
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    public Vector<String> get(String prefix) {
        char c;
        PrefixTree subset;
        if (prefix == null) {
            return null;
        }
        Vector<String> result = new Vector<String>();
        if (prefix.length() < 1) {
            return this.getAll();
        }
        if (this.ignoreCase) {
            prefix = prefix.toLowerCase();
        }
        if ((subset = this.collection.get(Character.valueOf(c = prefix.charAt(0)))) == null) {
            return result;
        }
        for (String substring : subset.get(prefix.substring(1))) {
            result.add(c + substring);
        }
        return result;
    }

    public Vector<String> getAll() {
        Vector<String> result = new Vector<String>();
        for (char c : this.collection.keySet()) {
            PrefixTree subset = this.collection.get(Character.valueOf(c));
            if (subset.isEmpty()) {
                result.add("" + c);
            }
            for (String substring : subset.getAll()) {
                result.add(c + substring);
            }
        }
        return result;
    }

    private boolean internAdd(String s) {
        char c;
        PrefixTree subtree;
        if (s == null) {
            return false;
        }
        if (s.length() < 1) {
            return false;
        }
        this.size = -1;
        if (this.ignoreCase) {
            s = s.toLowerCase();
        }
        if ((subtree = this.collection.get(Character.valueOf(c = s.charAt(0)))) == null) {
            subtree = new PrefixTree();
        }
        subtree.internAdd(s.substring(1));
        this.collection.put(Character.valueOf(c), subtree);
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.collection.isEmpty();
    }

    @Override
    public Iterator<String> iterator() {
        return this.getAll().iterator();
    }

    @Override
    public boolean remove(Object o) {
        if (o == null) {
            return false;
        }
        String s = o.toString().trim();
        if (s.length() < 1) {
            return true;
        }
        this.size = -1;
        char c = s.charAt(0);
        PrefixTree subset = this.collection.get(Character.valueOf(c));
        if (subset == null) {
            return false;
        }
        subset.remove(s.substring(1));
        if (subset.isEmpty()) {
            this.collection.remove(Character.valueOf(c));
        }
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> col) {
        for (Object o : col) {
            if (this.remove(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean retainAll(Collection<?> col) {
        Vector<String> all = this.getAll();
        for (String s : all) {
            if (col.contains(s) || this.remove(s)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int size() {
        if (this.size == -1) {
            this.size = this.getAll().size();
        }
        return this.size;
    }

    @Override
    public Object[] toArray() {
        return this.getAll().toArray();
    }

    @Override
    public <T> T[] toArray(T[] arg0) {
        return null;
    }

    public String toString() {
        return this.collection.toString();
    }

    public static void main(String[] args) {
        PrefixTree tree = new PrefixTree();
        tree.add("anton");
        tree.add("berta");
        tree.add("brett");
        tree.add("brot");
        tree.add("ei");
        tree.add("end");
        System.out.println(tree);
        System.out.println(tree.get("br"));
        tree.remove("brot");
        System.out.println(tree);
        System.out.println(tree.getAll());
        System.out.println(tree.get("br"));
        System.out.println(tree.get("e"));
    }
}

