/*
 * Decompiled with CFR 0.152.
 */
package de.srsoftware.tools.plugin;

import de.srsoftware.tools.plugin.ClassListener;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Stream;

public class JarWatchdog
extends Thread {
    private static final System.Logger LOGGER = System.getLogger(JarWatchdog.class.getSimpleName());
    private final Set<File> dirs = new HashSet<File>();
    private Runnable afterScan;
    private Runnable beforeScan;
    private ClassLoader context = null;
    private Duration delay = Duration.ofSeconds(30L);
    private final Set<File> loadedFiles = new HashSet<File>();
    private final Set<ClassListener> listeners = new HashSet<ClassListener>();
    private final Set<String> warned = new HashSet<String>();

    public JarWatchdog addDirectory(File dir) {
        this.dirs.add(dir);
        return this;
    }

    public JarWatchdog addListener(ClassListener listener) {
        this.listeners.add(listener);
        return this;
    }

    public JarWatchdog afterScan(Runnable afterScan) {
        this.afterScan = afterScan;
        return this;
    }

    private void announce(Class<?> clazz) {
        this.listeners.forEach(listener -> listener.classAdded(clazz));
    }

    public JarWatchdog beforeScan(Runnable beforeScan) {
        this.beforeScan = beforeScan;
        return this;
    }

    public JarWatchdog dropDirectory(File dir) {
        this.dirs.remove(dir);
        return this;
    }

    public JarWatchdog dropListener(ClassListener listener) {
        this.listeners.remove(listener);
        return this;
    }

    public JarWatchdog frequency(Duration newDelay) {
        this.delay = newDelay;
        return this;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private Stream<Class<?>> loadClassesFrom(File jarFile) {
        String filename = jarFile.getName();
        boolean silent = this.warned.contains(filename);
        if (this.loadedFiles.contains(jarFile)) {
            if (!silent) {
                LOGGER.log(System.Logger.Level.DEBUG, "{0} already scanned.", jarFile);
                this.warned.add(filename);
            }
            return Stream.of(new Class[0]);
        }
        ArrayList classes = new ArrayList();
        try (JarFile jar = new JarFile(jarFile);){
            Stream<Class<?>> stream;
            block20: {
                URLClassLoader loader = URLClassLoader.newInstance(new URL[]{new URI("jar:file:" + String.valueOf(jarFile) + "!/").toURL()}, this.context);
                try {
                    Enumeration<JarEntry> enumeration = jar.entries();
                    while (enumeration.hasMoreElements()) {
                        JarEntry entry = enumeration.nextElement();
                        if (!silent) {
                            LOGGER.log(System.Logger.Level.DEBUG, "Found entry: {0}", entry);
                        }
                        if (entry.isDirectory() || !entry.getName().endsWith(".class")) continue;
                        String className = entry.getName().substring(0, entry.getName().length() - 6).replace('/', '.');
                        if (!silent) {
                            LOGGER.log(System.Logger.Level.INFO, "Trying to load {0}", className);
                        }
                        Class<?> c = loader.loadClass(className);
                        if (!silent) {
                            LOGGER.log(System.Logger.Level.INFO, "{0} loaded.", c.getSimpleName());
                        }
                        classes.add(c);
                    }
                    this.loadedFiles.add(jarFile);
                    this.warned.remove(filename);
                    stream = classes.stream();
                    if (loader == null) break block20;
                }
                catch (Throwable throwable) {
                    if (loader != null) {
                        try {
                            loader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                loader.close();
            }
            return stream;
        }
        catch (Throwable e) {
            if (!silent) {
                LOGGER.log(System.Logger.Level.WARNING, "Failed to load classes from jar!");
                this.warned.add(filename);
            }
            return Stream.of(new Class[0]);
        }
    }

    @Override
    public void run() {
        try {
            while (true) {
                this.scan();
                Thread.sleep(this.delay);
            }
        }
        catch (InterruptedException e) {
            return;
        }
    }

    public void scan() {
        if (this.beforeScan != null) {
            this.beforeScan.run();
        }
        for (File dir : this.dirs) {
            this.scan(dir);
        }
        if (this.afterScan != null) {
            this.afterScan.run();
        }
    }

    private void scan(File dir) {
        File[] files;
        if (dir.exists() && dir.isDirectory() && (files = dir.listFiles()) != null) {
            for (File child : files) {
                if (child.isDirectory() || !child.canRead() || !child.getName().endsWith(".jar")) continue;
                this.loadClassesFrom(child).forEach(this::announce);
            }
        }
    }

    public JarWatchdog setContext(ClassLoader context) {
        this.context = context;
        return this;
    }
}

