/*
 * Decompiled with CFR 0.152.
 */
package de.srsoftware.tools;

import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.ResourceBundle;

public class ColorLogger
implements System.Logger {
    private static final DateFormat TIME = new SimpleDateFormat("hh:mm:ss.SSS");
    private static final DateFormat DATE = new SimpleDateFormat("yyyy-MM-dd");
    private static int rootLevel = System.Logger.Level.INFO.getSeverity();
    private static HashMap<String, Integer> instanceLevels = new HashMap();
    private static String lastDate = null;
    private final String name;

    public ColorLogger(String name) {
        this.name = name;
    }

    public ColorLogger(Class<?> clazz) {
        this(clazz.getSimpleName());
    }

    private String colorize(String message, int severity) {
        String color = severity >= System.Logger.Level.ERROR.getSeverity() ? "\u001b[0;31m" : (severity >= System.Logger.Level.WARNING.getSeverity() ? "\u001b[0;33m" : (severity >= System.Logger.Level.INFO.getSeverity() ? "\u001b[0;97m" : "\u001b[0;37m"));
        Date date = new Date();
        String day = DATE.format(date);
        StringBuilder sb = new StringBuilder();
        if (!day.equals(lastDate)) {
            lastDate = day;
            sb.append("\u001b[0;37m").append(day).append("\n");
        }
        return sb.append("\u001b[0;37m").append(TIME.format(date)).append(" [").append(this.name).append("]: ").append(color).append(message).append("\u001b[0m").toString();
    }

    private String format(String pattern, Object ... args) {
        for (int i = 0; i < args.length; ++i) {
            int pos;
            String key = "{" + i + "}";
            if (((String)pattern).contains(key) || (pos = ((String)pattern).indexOf("{}")) < 0) continue;
            pattern = ((String)pattern).substring(0, pos) + key + ((String)pattern).substring(pos + 2);
        }
        return MessageFormat.format((String)pattern, args);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isLoggable(System.Logger.Level level) {
        Integer loggerLevel = instanceLevels.get(this.name);
        if (loggerLevel == null) {
            loggerLevel = rootLevel;
        }
        return level.getSeverity() >= loggerLevel;
    }

    @Override
    public void log(System.Logger.Level level, ResourceBundle bundle, String msg, Throwable thrown) {
        if (this.isLoggable(level)) {
            System.out.println(this.colorize(msg, level.getSeverity()));
            thrown.printStackTrace(System.err);
        }
    }

    @Override
    public void log(System.Logger.Level level, ResourceBundle bundle, String format, Object ... params) {
        if (this.isLoggable(level)) {
            try {
                if (params != null && params.length > 0) {
                    format = this.format(format, params);
                }
                System.out.println(this.colorize(format, level.getSeverity()));
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
    }

    public static ColorLogger of(Class<?> clazz) {
        return new ColorLogger(clazz.getSimpleName());
    }

    public static void setRootLogLevel(System.Logger.Level newLevel) {
        rootLevel = newLevel.getSeverity();
    }

    public static void setLogLevel(String loggerName, System.Logger.Level newLevel) {
        int severity = newLevel.getSeverity();
        instanceLevels.put(loggerName, severity);
    }
}

