/*
 * Decompiled with CFR 0.152.
 */
package de.srsoftware.tools.jdbc;

import de.srsoftware.tools.jdbc.Condition;
import de.srsoftware.tools.jdbc.Mark;
import java.lang.invoke.CallSite;
import java.security.InvalidParameterException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class Query {
    private static final System.Logger LOG = System.getLogger(Query.class.getSimpleName());
    public static final Mark MARK = new Mark();

    private Query() {
    }

    public static DeleteQuery delete() {
        return new DeleteQuery();
    }

    public static SelectQuery select(String ... fields) {
        return new SelectQuery(fields);
    }

    public static InsertQuery insertInto(String table, String ... fields) {
        return new InsertQuery(table).fields(fields);
    }

    public static UpdateQuery update(String table) {
        return new UpdateQuery(table, false);
    }

    public static UpdateQuery updateIgnore(String table) {
        return new UpdateQuery(table, true);
    }

    public static class DeleteQuery {
        private String table;
        private Map<String, List<Condition>> conditions = new HashMap<String, List<Condition>>();

        private DeleteQuery() {
        }

        public DeleteQuery from(String table) {
            this.table = table;
            return this;
        }

        public DeleteQuery where(String field, Condition condition) {
            this.conditions.computeIfAbsent(field, k -> new ArrayList()).add(condition);
            return this;
        }

        public boolean execute(Connection conn) throws SQLException {
            ArrayList<Object> values = new ArrayList<Object>();
            StringBuilder sql = new StringBuilder();
            sql.append("DELETE FROM ");
            sql.append(this.table);
            ArrayList<CallSite> where = new ArrayList<CallSite>();
            for (String field : this.conditions.keySet()) {
                for (Condition sub : this.conditions.get(field)) {
                    where.add((CallSite)((Object)(field + sub.sql())));
                    values.addAll(sub.values());
                }
            }
            if (!where.isEmpty()) {
                sql.append(" WHERE ");
                sql.append(String.join((CharSequence)" AND ", where));
            }
            PreparedStatement stmt = conn.prepareStatement(sql.toString(), 1);
            for (int i = 0; i < values.size(); ++i) {
                stmt.setObject(i + 1, values.get(i));
            }
            return stmt.execute();
        }
    }

    public static class SelectQuery {
        private List<String> sort = new ArrayList<String>();
        private final String[] fields;
        private StringBuilder tables = new StringBuilder();
        private String lastTable;
        private Long limit;
        private Map<String, List<Condition>> conditions = new HashMap<String, List<Condition>>();
        private Long skip;
        private List<String> groupFields = new ArrayList<String>();

        private SelectQuery(String[] fields) {
            this.fields = fields;
        }

        private String compile(List<Object> values) {
            StringBuilder sb = new StringBuilder("SELECT ").append(String.join((CharSequence)", ", Arrays.asList(this.fields))).append(" ").append((CharSequence)this.tables);
            ArrayList<CallSite> where = new ArrayList<CallSite>();
            for (String field : this.conditions.keySet()) {
                for (Condition sub : this.conditions.get(field)) {
                    where.add((CallSite)((Object)(field + sub.sql())));
                    values.addAll(sub.values());
                }
            }
            if (!where.isEmpty()) {
                sb.append(" WHERE ");
                sb.append(String.join((CharSequence)" AND ", where));
            }
            if (!this.groupFields.isEmpty()) {
                sb.append(" GROUP BY ").append(String.join((CharSequence)", ", this.groupFields));
            }
            if (!this.sort.isEmpty()) {
                sb.append(" ORDER BY ").append(String.join((CharSequence)", ", this.sort));
            }
            if (this.limit != null) {
                sb.append(" LIMIT ").append(this.limit);
            }
            if (this.skip != null) {
                sb.append(" OFFSET ").append(this.skip);
            }
            return sb.toString();
        }

        public ResultSet exec(Connection conn) throws SQLException {
            ArrayList<Object> values = new ArrayList<Object>();
            String sql = this.compile(values);
            PreparedStatement stmt = conn.prepareStatement(sql);
            for (int i = 0; i < values.size(); ++i) {
                stmt.setObject(i + 1, values.get(i));
            }
            return stmt.executeQuery();
        }

        private String fill(String sql, ArrayList<Object> values) {
            while (!values.isEmpty()) {
                String string;
                Object o = values.removeFirst();
                if (o instanceof Number) {
                    Number num = (Number)o;
                    string = String.valueOf(num);
                } else {
                    string = "\"" + String.valueOf(o) + "\"";
                }
                String s = string;
                sql = sql.replaceFirst("\\?", s);
            }
            return sql;
        }

        public SelectQuery from(String table) {
            this.tables.append("FROM ").append(table);
            this.lastTable = table;
            return this;
        }

        public SelectQuery groupBy(String ... fields) {
            this.groupFields.addAll(Arrays.asList(fields));
            return this;
        }

        public SelectQuery leftJoin(String joiningColumn, String otherTable, String otherTableColumn) {
            if (this.lastTable == null) {
                throw new RuntimeException("Left join without calling from(\u2026) before!");
            }
            this.tables.append(" LEFT JOIN ").append(otherTable).append(" ON ").append(this.lastTable).append('.').append(joiningColumn).append(" = ").append(otherTable).append('.').append(otherTableColumn);
            this.lastTable = otherTable;
            return this;
        }

        public SelectQuery limit(long limit) {
            this.limit = limit;
            return this;
        }

        public SelectQuery skip(long count) {
            this.skip = count;
            return this;
        }

        public SelectQuery sort(String ... fields) {
            this.sort.addAll(Arrays.asList(fields));
            return this;
        }

        public String toString() {
            ArrayList<Object> values = new ArrayList<Object>();
            return this.fill(this.compile(values), values);
        }

        public SelectQuery where(String field, Condition condition) {
            this.conditions.computeIfAbsent(field, k -> new ArrayList()).add(condition);
            return this;
        }
    }

    public static class InsertQuery {
        private final String table;
        private String[] fields = null;
        private List<Object[]> valueSets = new ArrayList<Object[]>();

        private InsertQuery(String table) {
            this.table = table;
        }

        public PreparedStatement execute(Connection conn) throws SQLException {
            PreparedStatement stmt = conn.prepareStatement(this.sql(), 1);
            conn.setAutoCommit(false);
            for (Object[] arr : this.valueSets) {
                for (int i = 0; i < arr.length; ++i) {
                    stmt.setObject(i + 1, arr[i]);
                }
                stmt.execute();
            }
            conn.setAutoCommit(true);
            return stmt;
        }

        private InsertQuery fields(String[] fields) {
            this.fields = fields;
            return this;
        }

        public String sql() {
            String marks = Arrays.stream(this.fields).map(field -> "?").collect(Collectors.joining(", "));
            String names = String.join((CharSequence)", ", Arrays.asList(this.fields));
            return "INSERT INTO %s (%s) VALUES (%s)".formatted(this.table, names, marks);
        }

        public String toString() {
            return this.sql();
        }

        public InsertQuery values(Object ... values) {
            if (this.fields != null && this.fields.length != values.length) {
                throw new InvalidParameterException("Number of values must match the number of fields!");
            }
            this.valueSets.add(values);
            return this;
        }
    }

    public static class UpdateQuery {
        private final String table;
        private final boolean ignore;
        private int counter;
        private List<String> fields = new ArrayList<String>();
        private List<Integer> fieldInputs = new ArrayList<Integer>();
        private List<String> conditions = new ArrayList<String>();
        private List<Object> conditionInputs = new ArrayList<Object>();

        private UpdateQuery(String table, boolean ignore) {
            this.table = table;
            this.ignore = ignore;
            this.counter = 0;
        }

        private void addField(String field) {
            this.fields.add(field + " = ?");
            this.fieldInputs.add(this.counter++);
        }

        public String fill() {
            Object sql = this.sql();
            int pos = 0;
            Iterator<Object> iterator = this.fieldInputs.iterator();
            while (iterator.hasNext()) {
                int index = iterator.next();
                if ((pos = ((String)sql).indexOf("?", pos + 1)) < 0) {
                    return sql;
                }
                sql = ((String)sql).substring(0, pos) + "args[" + index + "]" + ((String)sql).substring(pos + 1);
            }
            for (Object obj : this.conditionInputs) {
                if ((pos = ((String)sql).indexOf("?", pos + 1)) < 0) {
                    return sql;
                }
                if (obj instanceof Mark) {
                    Mark mark = (Mark)obj;
                    sql = ((String)sql).substring(0, pos) + "args[" + mark.position() + "]" + ((String)sql).substring(pos + 1);
                    continue;
                }
                sql = ((String)sql).substring(0, pos) + String.valueOf(obj) + ((String)sql).substring(pos + 1);
            }
            return sql;
        }

        public PreparedUpdateQuery prepare(Connection conn) throws SQLException {
            LOG.log(System.Logger.Level.DEBUG, () -> "preparing " + String.valueOf(this));
            PreparedStatement stmt = conn.prepareStatement(this.sql());
            return new PreparedUpdateQuery(stmt, this.fieldInputs, this.conditionInputs);
        }

        public UpdateQuery set(String ... fields) {
            for (String field : fields) {
                this.addField(field);
            }
            return this;
        }

        public String sql() {
            StringBuilder sb = new StringBuilder("UPDATE ");
            if (this.ignore) {
                sb.append("IGNORE ");
            }
            sb.append(this.table).append(" SET ");
            sb.append(String.join((CharSequence)", ", this.fields));
            if (!this.conditions.isEmpty()) {
                sb.append(" WHERE ").append(String.join((CharSequence)" AND ", this.conditions));
            }
            return sb.toString();
        }

        public String toString() {
            return this.fill();
        }

        public UpdateQuery where(String field, Condition condition) {
            this.conditions.add(field + condition.sql());
            for (Object val : condition.values()) {
                if (val instanceof Mark) {
                    Mark mark = (Mark)val;
                    this.conditionInputs.add(mark.set(this.counter++));
                    continue;
                }
                this.conditionInputs.add(val);
            }
            return this;
        }
    }

    public static class PreparedUpdateQuery {
        private final PreparedStatement stmt;
        private final List<Object> conditionInputs;
        private final long counter;
        private final List<Integer> fieldInputs;

        private PreparedUpdateQuery(PreparedStatement stmt, List<Integer> fieldInputs, List<Object> conditionInputs) {
            this.stmt = stmt;
            this.conditionInputs = conditionInputs;
            this.fieldInputs = fieldInputs;
            this.counter = (long)fieldInputs.size() + conditionInputs.stream().filter(o -> o instanceof Mark).count();
        }

        public PreparedUpdateQuery apply(Object ... values) throws SQLException {
            if ((long)values.length != this.counter) {
                throw new InvalidParameterException("apply(\u2026) expected %s arguments, got %s!".formatted(this.counter, values.length));
            }
            int index = 0;
            Iterator<Object> iterator = this.fieldInputs.iterator();
            while (iterator.hasNext()) {
                int fieldInputIndex = iterator.next();
                this.stmt.setObject(++index, values[fieldInputIndex]);
            }
            for (Object obj : this.conditionInputs) {
                if (obj instanceof Mark) {
                    Mark mark = (Mark)obj;
                    this.stmt.setObject(++index, values[mark.position()]);
                    continue;
                }
                this.stmt.setObject(++index, obj);
            }
            LOG.log(System.Logger.Level.TRACE, () -> " \u2192 applying (" + String.join((CharSequence)", ", Arrays.stream(values).map(o -> String.valueOf(o)).toList()) + ")");
            this.stmt.execute();
            return this;
        }
    }
}

