/*
 * Decompiled with CFR 0.152.
 */
package de.srsoftware.tools.jdbc;

import java.util.Arrays;
import java.util.List;

public class Condition {
    private final List<Object> values;
    private final String sql;

    private Condition(String sql, Object ... values) {
        this.sql = sql;
        this.values = List.of(values);
    }

    public static Condition equal(Object value) {
        return new Condition(" = ?", value);
    }

    public static Condition in(Object ... values) {
        List<String> marks = Arrays.stream(values).map(o -> "?").toList();
        return new Condition(" IN (%s)".formatted(String.join((CharSequence)", ", marks)), values);
    }

    public static Condition lessThan(Object value) {
        return new Condition(" < ?", value);
    }

    public static Condition moreThan(Object value) {
        return new Condition(" > ?", value);
    }

    public static Condition notIn(Object ... values) {
        List<String> marks = Arrays.stream(values).map(o -> "?").toList();
        return new Condition(" NOT IN (%s)".formatted(String.join((CharSequence)", ", marks)), values);
    }

    public static Condition like(String txt) {
        return new Condition(" LIKE ?", txt);
    }

    public String sql() {
        return this.sql;
    }

    public List<Object> values() {
        return this.values;
    }
}

