/*
 * Decompiled with CFR 0.152.
 */
package de.srsoftware.tools;

import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class Query {
    private static final System.Logger LOG = System.getLogger(Query.class.getSimpleName());

    private Query() {
    }

    public static Map<String, Object> decode(String query) {
        String[] parts;
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        if (query == null) {
            return map;
        }
        for (String part : parts = query.split("&")) {
            String[] keyVal = part.split("=", 2);
            String key = URLDecoder.decode(keyVal[0], StandardCharsets.UTF_8);
            String val = URLDecoder.decode(keyVal[1], StandardCharsets.UTF_8);
            Query.insertInto(map, key, val);
        }
        return map;
    }

    private static void insertInto(HashMap<String, Object> map, String key, String value) {
        String[] parts = key.split("\\[|]\\[|]");
        Map<String, Object> current = map;
        for (int i = 0; i < parts.length; ++i) {
            if (parts[i].isEmpty()) continue;
            if (i == parts.length - 1) {
                Object existing = current.get(parts[i]);
                if (existing == null) {
                    current.put(parts[i], value);
                    continue;
                }
                if (existing instanceof List) {
                    ((List)existing).add(value);
                    continue;
                }
                ArrayList<String> list = new ArrayList<String>();
                list.add((String)existing);
                list.add(value);
                current.put(parts[i], list);
                continue;
            }
            Object next = current.get(parts[i]);
            if (!(next instanceof Map)) {
                next = new LinkedHashMap();
                current.put(parts[i], next);
            }
            current = (Map)next;
        }
    }

    public static Optional<String> encode(Map<String, ?> query) {
        if (query == null) {
            return Optional.empty();
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, ?> entry : query.entrySet()) {
            if (!sb.isEmpty()) {
                sb.append("&");
            }
            String key = URLEncoder.encode(entry.getKey(), StandardCharsets.UTF_8);
            Object val = entry.getValue();
            if (val instanceof Number) {
                Number num = (Number)val;
                sb.append(key).append("=").append(num);
            }
            if (val instanceof String) {
                String stringValue = (String)val;
                stringValue = URLEncoder.encode(stringValue, StandardCharsets.UTF_8);
                sb.append(key).append("=").append(stringValue);
            }
            if (val instanceof Collection) {
                Collection list = (Collection)val;
                String listString = list.stream().map(o -> key + "=" + String.valueOf(o)).collect(Collectors.joining("&"));
                sb.append(listString);
            }
            if (!(val instanceof Map)) continue;
            Map map = (Map)val;
            String pathList = Query.traverse(map).stream().map(o -> key + o).collect(Collectors.joining("&"));
            sb.append(pathList);
        }
        return Optional.of(sb.toString());
    }

    private static List<String> traverse(Map<?, ?> map) {
        ArrayList<String> list = new ArrayList<String>();
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            String key = "[" + URLEncoder.encode(entry.getKey().toString(), StandardCharsets.UTF_8) + "]";
            Object val = entry.getValue();
            if (val instanceof Map) {
                Map nested = (Map)val;
                Query.traverse(nested).forEach(o -> list.add(key + o));
                continue;
            }
            list.add(key + "=" + URLEncoder.encode(val.toString(), StandardCharsets.UTF_8));
        }
        return list;
    }
}

