/*
 * Decompiled with CFR 0.152.
 */
package de.srsoftware.tools;

import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Stack;

public class Path
extends Stack<String> {
    private Path() {
    }

    public boolean endsWith(String s) {
        return ((String)this.get(this.size() - 1)).endsWith(s);
    }

    public boolean equals(String s) {
        return this.size() == 1 && ((String)this.get(0)).equals(s);
    }

    public static Path of(String requestPath) {
        Path path = new Path();
        if (requestPath == null || requestPath.isBlank()) {
            return path;
        }
        String[] parts = requestPath.split("/");
        for (int i = parts.length - 1; i > -1; --i) {
            if (i <= 0 && parts[i].isBlank()) continue;
            path.push(parts[i]);
        }
        return path;
    }

    @Override
    public synchronized String pop() {
        if (this.isEmpty()) {
            return null;
        }
        return URLDecoder.decode((String)super.pop(), StandardCharsets.UTF_8);
    }

    @Override
    public synchronized String peek() {
        if (this.isEmpty()) {
            return null;
        }
        return URLDecoder.decode((String)super.peek(), StandardCharsets.UTF_8);
    }

    @Override
    public synchronized String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = this.size(); i > 0; --i) {
            sb.append("/").append((String)this.get(i - 1));
        }
        return sb.isEmpty() ? "" : sb.substring(1);
    }
}

