/*
 * Decompiled with CFR 0.152.
 */
package de.srsoftware.tools;

import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpExchange;
import de.srsoftware.tools.Optionals;
import de.srsoftware.tools.SessionToken;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public abstract class Cookie
implements Map.Entry<String, String> {
    static final System.Logger LOG = System.getLogger(SessionToken.class.getSimpleName());
    private final String key;
    private String value = null;

    Cookie(String key, String value) {
        this.key = key;
        this.setValue(value);
    }

    public <T extends Cookie> T addTo(Headers headers) {
        LOG.log(System.Logger.Level.INFO, "sending cookie {0}={1}", this.key, this.value);
        headers.add("Set-Cookie", "%s=%s".formatted(this.key, this.value));
        return (T)this;
    }

    public <T extends Cookie> T addTo(HttpExchange ex) {
        return this.addTo(ex.getResponseHeaders());
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    protected static List<String> of(HttpExchange ex) {
        return Optionals.nullable((Object)ex.getRequestHeaders().get("Cookie")).stream().flatMap(Collection::stream).flatMap(s -> Arrays.stream(s.split(";"))).map(String::trim).peek(cookie -> LOG.log(System.Logger.Level.INFO, "received cookie {0}", cookie)).toList();
    }

    @Override
    public String setValue(String s) {
        String oldVal = this.value;
        this.value = s;
        return oldVal;
    }
}

