/*
 * Decompiled with CFR 0.152.
 */
package de.srsoftware.tools;

import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import com.sun.net.httpserver.HttpsExchange;
import de.srsoftware.tools.Error;
import de.srsoftware.tools.HttpError;
import de.srsoftware.tools.Optionals;
import de.srsoftware.tools.Payload;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.json.JSONArray;
import org.json.JSONObject;

public abstract class PathHandler
implements HttpHandler {
    public static final String AUTHORIZATION = "Authorization";
    public static final String CONTENT_TYPE = "Content-Type";
    public static final String DEFAULT_LANGUAGE = "en";
    public static final String DELETE = "DELETE";
    private static final String FORWARDED_HOST = "x-forwarded-host";
    public static final String GET = "GET";
    public static final String HOST = "host";
    public static final String JSON = "application/json";
    public static System.Logger LOG = System.getLogger(PathHandler.class.getSimpleName());
    public static final String POST = "POST";
    private String[] paths;

    public static boolean badRequest(HttpExchange ex, byte[] bytes) throws IOException {
        return PathHandler.sendContent(ex, 400, bytes);
    }

    public static boolean badRequest(HttpExchange ex, Object o) throws IOException {
        return PathHandler.sendContent(ex, 400, o);
    }

    public Bond bindPath(String ... path) {
        return new Bond(path);
    }

    public boolean doDelete(String path, HttpExchange ex) throws IOException {
        return PathHandler.notFound(ex);
    }

    public boolean doGet(String path, HttpExchange ex) throws IOException {
        return PathHandler.notFound(ex);
    }

    public boolean doPost(String path, HttpExchange ex) throws IOException {
        return PathHandler.notFound(ex);
    }

    @Override
    public void handle(HttpExchange ex) throws IOException {
        String path = this.relativePath(ex);
        String method = ex.getRequestMethod();
        LOG.log(System.Logger.Level.INFO, "{0} {1}", method, path);
        boolean ignored = switch (method) {
            case DELETE -> this.doDelete(path, ex);
            case GET -> this.doGet(path, ex);
            case POST -> this.doPost(path, ex);
            default -> false;
        };
        ex.getResponseBody().close();
    }

    public String relativePath(HttpExchange ex) {
        int pos;
        Object requestPath = ex.getRequestURI().toString();
        for (String path : this.paths) {
            if (!((String)requestPath).startsWith(path)) continue;
            requestPath = ((String)requestPath).substring(path.length());
            break;
        }
        if (!((String)requestPath).startsWith("/")) {
            requestPath = "/" + (String)requestPath;
        }
        if ((pos = ((String)requestPath).indexOf("?")) >= 0) {
            requestPath = ((String)requestPath).substring(0, pos);
        }
        return requestPath;
    }

    public static String body(HttpExchange ex) throws IOException {
        return new String(ex.getRequestBody().readAllBytes(), StandardCharsets.UTF_8);
    }

    public static Optional<String> getAuthToken(HttpExchange ex) {
        return PathHandler.getHeader(ex, AUTHORIZATION);
    }

    public static Optional<BasicAuth> getBasicAuth(HttpExchange ex) {
        return PathHandler.getAuthToken(ex).filter(token -> token.startsWith("Basic ")).map(token -> token.substring(6)).map(Base64.getDecoder()::decode).map(bytes -> new String((byte[])bytes, StandardCharsets.UTF_8)).map(token -> token.split(":", 2)).map(arr -> new BasicAuth(arr[0], arr[1]));
    }

    public static Optional<String> getBearer(HttpExchange ex) {
        return PathHandler.getAuthToken(ex).filter(token -> token.startsWith("Bearer ")).map(token -> token.substring(7));
    }

    public static Optional<String> getHeader(HttpExchange ex, String key) {
        return Optionals.nullable((Object)ex.getRequestHeaders().get(key)).map(Collection::stream).flatMap(Stream::findFirst);
    }

    public static String hostname(HttpExchange ex) {
        Headers headers = ex.getRequestHeaders();
        String host = headers.getFirst(FORWARDED_HOST);
        if (host == null) {
            host = headers.getFirst(HOST);
        }
        String proto = Optionals.nullable((Object)headers.getFirst("X-forwarded-proto")).orElseGet(() -> ex instanceof HttpsExchange ? "https" : "http");
        return host == null ? null : proto + "://" + host;
    }

    public static JSONObject json(HttpExchange ex) throws IOException {
        return new JSONObject(PathHandler.body(ex));
    }

    public static String language(HttpExchange ex) {
        return PathHandler.getHeader(ex, "Accept-Language").map(s -> Arrays.stream(s.split(","))).flatMap(Stream::findFirst).orElse(DEFAULT_LANGUAGE);
    }

    public static boolean notFound(HttpExchange ex) throws IOException {
        LOG.log(System.Logger.Level.ERROR, "not implemented");
        return PathHandler.sendEmptyResponse(404, ex);
    }

    public Map<String, String> queryParam(HttpExchange ex) {
        return Arrays.stream(ex.getRequestURI().getQuery().split("&")).map(s -> s.split("=", 2)).collect(Collectors.toMap(arr -> arr[0], arr -> arr[1]));
    }

    public static boolean sendEmptyResponse(int statusCode, HttpExchange ex) throws IOException {
        ex.sendResponseHeaders(statusCode, 0L);
        return false;
    }

    public static boolean sendRedirect(HttpExchange ex, String url) throws IOException {
        ex.getResponseHeaders().add("Location", url);
        return PathHandler.sendEmptyResponse(302, ex);
    }

    public static boolean sendContent(HttpExchange ex, int status, byte[] bytes) throws IOException {
        LOG.log(System.Logger.Level.DEBUG, "sending {0} response\u2026", status);
        ex.sendResponseHeaders(status, bytes.length);
        ex.getResponseBody().write(bytes);
        return true;
    }

    public static boolean sendContent(HttpExchange ex, int status, Object o) throws IOException {
        HttpError error;
        if (o instanceof Payload) {
            Payload payload = (Payload)o;
            o = payload.get();
        }
        if (o instanceof List) {
            List list = (List)o;
            o = new JSONArray((Collection)list);
        }
        if (o instanceof Map) {
            Map map = (Map)o;
            o = new JSONObject(map);
        }
        if (o instanceof HttpError) {
            error = (HttpError)((Object)o);
            return PathHandler.sendContent(ex, error.code(), error.json());
        }
        if (o instanceof Error) {
            error = (Error)o;
            return PathHandler.serverError(ex, error.json());
        }
        if (o instanceof JSONObject || o instanceof JSONArray) {
            ex.getResponseHeaders().add(CONTENT_TYPE, JSON);
        }
        return PathHandler.sendContent(ex, status, o.toString().getBytes(StandardCharsets.UTF_8));
    }

    public static boolean sendContent(HttpExchange ex, byte[] bytes) throws IOException {
        return PathHandler.sendContent(ex, 200, bytes);
    }

    public static boolean sendContent(HttpExchange ex, Object o) throws IOException {
        return PathHandler.sendContent(ex, 200, o);
    }

    public static boolean serverError(HttpExchange ex, Object o) throws IOException {
        PathHandler.sendContent(ex, 500, o);
        return false;
    }

    public static String url(HttpExchange ex) {
        return PathHandler.hostname(ex) + String.valueOf(ex.getRequestURI());
    }

    public class Bond {
        Bond(String[] paths) {
            PathHandler.this.paths = paths;
        }

        public PathHandler on(HttpServer server) {
            for (String path : PathHandler.this.paths) {
                server.createContext(path, PathHandler.this);
            }
            return PathHandler.this;
        }
    }

    public record BasicAuth(String userId, String pass) {
    }
}

