/*
 * Decompiled with CFR 0.152.
 */
package de.srsoftware.tools.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectComboBox
extends JComboBox<Object> {
    private static final Logger LOG = LoggerFactory.getLogger(SelectComboBox.class);
    private static final long serialVersionUID = -3123598811223301887L;
    private Collection<? extends Object> elements = new Vector<Object>();
    private JTextField inputField;
    private HashSet<DeleteListener> deleteListeners = new HashSet();
    private HashSet<EnterListener> enterListeners = new HashSet();
    private HashSet<TextListener> textListeners = new HashSet();

    public SelectComboBox(Collection<? extends Object> elements) {
        this.setElements(elements);
        this.setEditable(true);
        this.inputField = (JTextField)this.getEditor().getEditorComponent();
        this.inputField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                SelectComboBox.this.handleKey(e);
            }
        });
    }

    public String getText() {
        return this.inputField.getText();
    }

    protected void handleKey(KeyEvent e) {
        String tx = this.inputField.getText();
        switch (e.getKeyCode()) {
            case 16: 
            case 17: 
            case 27: 
            case 35: 
            case 36: 
            case 224: {
                break;
            }
            case 127: {
                if ((e.getModifiersEx() & 0x40) <= 0) break;
                this.deleteListeners.forEach(l -> l.textDeleted(tx));
                this.inputField.setText("");
                this.hidePopup();
                break;
            }
            case 10: {
                this.hidePopup();
                this.enterListeners.forEach(l -> l.textEntered(tx));
                break;
            }
            case 40: {
                if (!tx.isEmpty()) break;
            }
            default: {
                this.showFiltered();
            }
        }
        this.textListeners.forEach(l -> l.textUpdated(tx));
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.setPreferredSize(new Dimension(600, 400));
        frame.setDefaultCloseOperation(3);
        frame.setLayout(new BorderLayout());
        JLabel textDisplay = new JLabel("<html>");
        textDisplay.setPreferredSize(new Dimension(800, 600));
        frame.add((Component)textDisplay, "Center");
        HashSet<String> elements = new HashSet<String>();
        elements.addAll(List.of("", "Lion", "Lion ", " Lion", "LionKing", "Mufasa", "Nala", "KingNala", "Animals", "Anims", "Fish", "Jelly Fish", "I am the boss"));
        SelectComboBox select = new SelectComboBox(elements).onUpdateText(tx -> LOG.debug("Current text: {}", (Object)tx)).onEnter(entered -> textDisplay.setText(textDisplay.getText() + entered + "<br/>")).onDelete(elements::remove);
        frame.add((Component)select, "North");
        frame.pack();
        frame.setVisible(true);
    }

    public SelectComboBox onDelete(DeleteListener deleteListener) {
        this.deleteListeners.add(deleteListener);
        return this;
    }

    public SelectComboBox onEnter(EnterListener enterListener) {
        this.enterListeners.add(enterListener);
        return this;
    }

    public SelectComboBox onUpdateText(TextListener textListener) {
        this.textListeners.add(textListener);
        return this;
    }

    public SelectComboBox setElements(Collection<? extends Object> values) {
        this.elements = values;
        return this;
    }

    public SelectComboBox setText(String newVal) {
        this.inputField.setText(newVal);
        return this;
    }

    private void showFiltered() {
        String text = this.inputField.getText();
        this.hidePopup();
        if (this.elements == null || this.elements.isEmpty()) {
            LOG.info("No items to display!");
            return;
        }
        String lower = text.toLowerCase();
        Stream<String> stream = this.elements.stream().map(Object::toString).filter(s -> !s.isBlank());
        if (lower.isEmpty()) {
            LOG.debug("lower is blank!");
        } else {
            stream = stream.filter(element -> element.toString().toLowerCase().contains(lower));
        }
        List filtered = stream.map(String::trim).distinct().sorted().collect(Collectors.toList());
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.getModel();
        model.removeAllElements();
        if (!filtered.isEmpty()) {
            model.addAll(filtered);
            this.showPopup();
        }
        this.inputField.setText(text);
    }

    public static interface TextListener {
        public void textUpdated(String var1);
    }

    public static interface EnterListener {
        public void textEntered(String var1);
    }

    public static interface DeleteListener {
        public void textDeleted(String var1);
    }
}

