/*
 * Decompiled with CFR 0.152.
 */
package de.srsoftware.tools.container;

import de.srsoftware.tools.container.Container;
import de.srsoftware.tools.container.Error;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;

public class Payload<Content>
implements Container<Content> {
    private final Content object;

    public Payload(Content object) {
        this.object = object;
    }

    public Content get() {
        return this.object;
    }

    public static <P> Container<P> of(P object) {
        if (object == null) {
            return Error.error("Can not create payload of NULL value!", new Object[0]);
        }
        return new Payload<P>(object);
    }

    @Override
    public Optional<Content> optional() {
        return Optional.ofNullable(this.object);
    }

    @Override
    public <Inner> Stream<Inner> stream() throws ClassCastException {
        Content Content = this.object;
        if (Content instanceof Collection) {
            Collection coll;
            Collection collection = coll = (Collection)Content;
            return collection.stream();
        }
        Content inner = this.object;
        return Stream.of(inner);
    }

    @Override
    public <Inner> Stream<Container<Inner>> streamContained() {
        Content Content = this.object;
        if (Content instanceof Collection) {
            Collection coll = (Collection)Content;
            try {
                Collection collection = coll;
                return collection.stream().map(Payload::of);
            }
            catch (ClassCastException cce) {
                return Stream.of(Error.error(cce, "Failed to cast %s", coll.getClass().getSimpleName()));
            }
        }
        try {
            Content inner = this.object;
            return Stream.of(Payload.of(inner));
        }
        catch (ClassCastException cce) {
            return Stream.of(Error.error(cce, "Failed to cast %s", this.object.getClass().getSimpleName()));
        }
    }

    public <T> T then(Function<Payload<Content>, T> mapper) {
        return mapper.apply(this);
    }

    public String toString() {
        return this.object.toString();
    }
}

