/*
 * Decompiled with CFR 0.152.
 */
package de.srsoftware.tools.container;

import de.srsoftware.tools.container.Container;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import org.json.JSONObject;

public class Error<None>
implements Container<None> {
    public static final String DATA = "data";
    public static final String EXCEPTIONS = "exceptions";
    public static final String MESSAGE = "message";
    private final List<Exception> exceptions = new ArrayList<Exception>();
    private final Map<String, Object> data = new HashMap<String, Object>();
    private final String message;

    public Error(String message, Map<String, Object> data, Collection<Exception> exceptions) {
        this.message = message;
        if (data != null) {
            this.data.putAll(data);
        }
        if (exceptions != null) {
            this.exceptions.addAll(exceptions);
        }
    }

    public Error<None> add(Exception exception) {
        this.exceptions.add(exception);
        return this;
    }

    public Error<None> addData(Object ... tokens) {
        for (int i = 0; i < tokens.length - 1; i += 2) {
            this.data.put(tokens[i].toString(), tokens[i + 1]);
        }
        return this;
    }

    public Map<String, Object> data() {
        return this.data;
    }

    public static <T> Error<T> error(String message, Object ... fills) {
        return new Error(Error.fill(message, fills), null, null);
    }

    public static <T> Error<T> error(Exception exception, String message, Object ... fills) {
        return new Error(Error.fill(message, fills), null, exception == null ? null : List.of(exception));
    }

    public static <T> Error<T> error(Collection<Exception> exceptions, String message, Object ... fills) {
        return new Error(Error.fill(message, fills), null, exceptions);
    }

    public static <T> Error<T> error(Map<String, Object> data, String message, Object ... fills) {
        return new Error(Error.fill(message, fills), data, null);
    }

    public static <T> Error<T> error(Map<String, Object> data, Exception exception, String message, Object ... fills) {
        return new Error(Error.fill(message, fills), data, exception == null ? null : List.of(exception));
    }

    public static <T> Error<T> error(Map<String, Object> data, Collection<Exception> exceptions, String message, Object ... fills) {
        return new Error(Error.fill(message, fills), data, exceptions);
    }

    public Collection<Exception> exceptions() {
        return this.exceptions;
    }

    private static String fill(String message, Object ... fills) {
        return fills == null || fills.length < 1 ? message : MessageFormat.format(message, fills);
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    public JSONObject json() {
        JSONObject json = new JSONObject(Map.of(MESSAGE, this.message));
        if (!this.exceptions.isEmpty()) {
            json.put(EXCEPTIONS, this.exceptions);
        }
        if (!this.data.isEmpty()) {
            json.put(DATA, this.data);
        }
        return json;
    }

    public String message() {
        return this.message;
    }

    @Override
    public Optional<None> optional() {
        return Optional.empty();
    }

    @Override
    public <Inner> Stream<Inner> stream() {
        return Stream.empty();
    }

    @Override
    public <Inner> Stream<Container<Inner>> streamContained() {
        return Stream.of(this.transform());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.message);
        for (Exception ex : this.exceptions) {
            sb.append("\n").append(ex.getMessage());
        }
        return sb.toString();
    }

    public <T> T then(Function<Error<None>, T> mapper) {
        return mapper.apply(this);
    }

    public <NewType> Error<NewType> transform() {
        return Error.error(this.data, this.exceptions, this.message, new Object[0]);
    }

    public Optional<Error<None>> wrap() {
        return Optional.of(this);
    }
}

