/*
 * Decompiled with CFR 0.152.
 */
package de.srsoftware.tools.container;

import de.srsoftware.tools.container.Error;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;

public interface Container<Content> {
    default public boolean isEmpty() {
        return this.optional().isEmpty();
    }

    default public <T> T map(Function<Container<Content>, T> mapper) {
        return mapper.apply(this);
    }

    public Optional<Content> optional();

    public <Inner> Stream<Container<Inner>> streamContained();

    public <Inner> Stream<Inner> stream();

    public static <T> Error<T> transform(Container<?> res) {
        Error<Object> error;
        if (res instanceof Error) {
            Error err = (Error)res;
            error = err.transform();
        } else {
            error = Error.error("Invalid parameter: {0}", res.getClass().getSimpleName());
        }
        return error;
    }
}

