/*
 * Decompiled with CFR 0.152.
 */
package de.srsoftware.localconfig;

import de.srsoftware.tools.translations.Translation;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.rmi.UnexpectedException;
import java.util.AbstractMap;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Configuration
extends TreeMap<String, String> {
    private static final long serialVersionUID = 3954350882528757083L;
    private static final Logger log = LoggerFactory.getLogger(Configuration.class);
    private File configFile = null;

    public Configuration(String filename) {
        this(new File(filename));
    }

    public Configuration(File f) {
        this.configFile = f;
        try {
            this.load();
        }
        catch (IOException e) {
            log.info(Translation.get((Object)this, (String)"Trying to load configuration from non-existing file ({}).", (Object[])new Object[0]), (Object)f);
            log.info(Translation.get((Object)this, (String)"New configuration file will be created on save.", (Object[])new Object[0]));
        }
    }

    public void copy(Configuration source, String field) {
        this.put(field, (String)source.get(field));
    }

    public static String dir(String programName) {
        return System.getProperty("user.home") + "/.config/" + programName;
    }

    public File file() {
        return this.configFile;
    }

    public String getOrAdd(String key, String defaultValue) throws IOException {
        String s = (String)this.get(key);
        if (s != null) {
            return s;
        }
        this.put(key, defaultValue);
        this.save();
        return defaultValue;
    }

    public boolean getOrAdd(String key, boolean defaultValue) throws IOException {
        Boolean b = this.getBool(key);
        if (b != null) {
            return b;
        }
        this.put(key, defaultValue ? "true" : "false");
        this.save();
        return defaultValue;
    }

    public double getOrAdd(String key, double defaultValue) throws IOException {
        Double d = this.getDouble(key);
        if (d != null) {
            return d;
        }
        this.put(key, "" + defaultValue);
        this.save();
        return defaultValue;
    }

    public int getOrAdd(String key, int defaultValue) throws IOException {
        Integer i = this.getInt(key);
        if (i != null) {
            return i;
        }
        this.put(key, "" + defaultValue);
        this.save();
        return defaultValue;
    }

    public Boolean getBool(String key) {
        String s = (String)this.get(key);
        if (s == null) {
            return false;
        }
        return (s = s.trim().toLowerCase()).equals("true") || s.equals("1");
    }

    public Double getDouble(String key) {
        String s = (String)this.get(key);
        if (s == null) {
            return null;
        }
        return Double.parseDouble(s);
    }

    public Integer getInt(String key) {
        String s = (String)this.get(key);
        if (s == null) {
            return null;
        }
        return Integer.parseInt(s);
    }

    public static AbstractMap.SimpleEntry<String, String> keyValue(String line) throws UnexpectedException {
        String[] parts = line.split("=", 2);
        if (parts.length < 2) {
            throw new UnexpectedException("Not a key-value pair: " + line);
        }
        return new AbstractMap.SimpleEntry<String, String>(parts[0].trim(), parts[1].trim());
    }

    private void load() throws IOException {
        BufferedReader file = new BufferedReader(new FileReader(this.configFile));
        String line = null;
        while ((line = file.readLine()) != null) {
            if ((line = Configuration.uncomment(line)).trim().isEmpty()) continue;
            AbstractMap.SimpleEntry<String, String> entry = Configuration.keyValue(line);
            this.put(entry.getKey(), entry.getValue());
        }
        file.close();
    }

    @Override
    public String put(String key, String value) {
        return super.put(key.trim(), value.trim());
    }

    @Override
    public String put(String key, Number value) {
        return this.put(key, "" + value);
    }

    @Override
    public String put(String key, boolean value) {
        return this.put(key, value ? "true" : "false");
    }

    public void save() throws IOException {
        this.configFile.getParentFile().mkdirs();
        FileWriter file = new FileWriter(this.configFile);
        for (Map.Entry entry : this.entrySet()) {
            file.write((String)entry.getKey() + " = " + (String)entry.getValue() + "\n");
        }
        file.close();
    }

    public void saveAs(File file) throws IOException {
        this.configFile = file;
        this.save();
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getSimpleName() + ":\n");
        for (Map.Entry entry : this.entrySet()) {
            sb.append("\t" + (String)entry.getKey() + " = " + (String)entry.getValue() + "\n");
        }
        return sb.toString();
    }

    public static String uncomment(String line) {
        String[] parts = line.split("#", 2);
        return parts[0];
    }
}

