/*
 * Decompiled with CFR 0.152.
 */
package de.srsoftware.document.zugferd.data;

import de.srsoftware.document.zugferd.data.TaxSet;
import de.srsoftware.document.zugferd.data.TaxType;
import java.util.Objects;

public final class CombinedTaxSet
implements TaxSet {
    private long basisAmount;
    private final long percent;
    private final TaxType type;

    public CombinedTaxSet(long basisAmount, long percent, TaxType type) {
        this.basisAmount = basisAmount;
        this.percent = percent;
        this.type = type;
    }

    public void add(long amount) {
        this.basisAmount += amount;
    }

    public long basisAmount() {
        return this.basisAmount;
    }

    public long calculatedAmount() {
        return this.basisAmount() * this.percent() / 10000L;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        CombinedTaxSet that = (CombinedTaxSet)obj;
        return this.basisAmount == that.basisAmount && this.percent == that.percent && Objects.equals((Object)this.type, (Object)that.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.basisAmount, this.percent, this.type});
    }

    @Override
    public long percent() {
        return this.percent;
    }

    public String toString() {
        return "CombinedTaxSet[basisAmount=" + this.basisAmount + ", percent=" + this.percent + ", type=" + String.valueOf((Object)this.type) + "]";
    }

    @Override
    public TaxType type() {
        return this.type;
    }
}

