/*
 * Decompiled with CFR 0.152.
 */
package de.srsoftware.document.zugferd;

import de.srsoftware.document.api.BytesContent;
import de.srsoftware.document.api.Content;
import de.srsoftware.document.api.Document;
import de.srsoftware.document.api.DocumentRegistry;
import de.srsoftware.document.api.RenderError;
import de.srsoftware.document.api.RenderResult;
import de.srsoftware.document.mustang.A3Exporter;
import de.srsoftware.document.processor.FileProcessor;
import de.srsoftware.document.processor.weasyprint.WeasyDoc;
import de.srsoftware.document.zugferd.data.DocumentData;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.pdfbox.Loader;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.common.PDMetadata;
import org.apache.xmpbox.schema.PDFAIdentificationSchema;
import org.apache.xmpbox.xml.DomXmpParser;
import org.apache.xmpbox.xml.XmpParsingException;

public class Zugferd
implements Document {
    private static final System.Logger LOG = System.getLogger(Zugferd.class.getSimpleName());
    private final DocumentRegistry registry;

    public Zugferd(DocumentRegistry registry) {
        this.registry = registry;
    }

    private byte[] combine(Content pdf, Content xml, String profile, String creator, String producer, DocumentData docData) throws IOException {
        PDDocument doc = Loader.loadPDF((byte[])pdf.bytes());
        return this.getExporter(doc).setAuthor(docData.author().name()).setTitle(docData.documentNumber()).setProducer(producer).setCreator(creator).setProfile(profile).setXML(xml.bytes()).export();
    }

    public String description() {
        return "Zugferd-PDF mit eingebettetem XML";
    }

    public String id() {
        return "Zugferd";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private A3Exporter getExporter(PDDocument doc) throws IOException {
        switch (this.getPDFAVersion(doc)) {
            case 1: {
                throw Zugferd.notImplemented();
            }
            case 3: {
                return new A3Exporter(doc);
            }
            default: {
                throw new IllegalArgumentException("PDF-A version not supported");
            }
        }
    }

    private int getPDFAVersion(PDDocument document) throws IOException {
        PDMetadata metadata = document.getDocumentCatalog().getMetadata();
        if (metadata != null) {
            try {
                PDFAIdentificationSchema pdfaSchema = new DomXmpParser().parse((InputStream)metadata.createInputStream()).getPDFAIdentificationSchema();
                if (pdfaSchema != null) {
                    return pdfaSchema.getPart();
                }
            }
            catch (XmpParsingException e) {
                LOG.log(System.Logger.Level.ERROR, "XmpParsingException", (Throwable)e);
            }
        }
        return 0;
    }

    public String mimeType() {
        return "image/pdf";
    }

    public String name() {
        return "zugferd.pdf";
    }

    private static RuntimeException notImplemented() {
        return new RuntimeException("not implemented");
    }

    public RenderResult render(Map<String, Object> data) {
        RenderResult xmlResult;
        Map map;
        Object object = data.get("xml");
        if (!(object instanceof Map)) {
            return RenderError.of((String)"Data is missing content for key {0}", (Object[])new Object[]{"xml"});
        }
        Map xmlConfig = (Map)object;
        Object object2 = data.get("pdf");
        if (!(object2 instanceof Map)) {
            return RenderError.of((String)"Data is missing content for key {0}", (Object[])new Object[]{"pdf"});
        }
        Map pdfConfig = (Map)object2;
        Object object3 = data.get("producer");
        if (!(object3 instanceof String)) {
            return RenderError.of((String)"Data is missing content for key {0}", (Object[])new Object[]{"producer"});
        }
        String producer = (String)object3;
        Object v = xmlConfig.get("profile");
        if (!(v instanceof String)) {
            return RenderError.of((String)"Data is missing content for key {0}", (Object[])new Object[]{"xml.profile"});
        }
        String profile = (String)v;
        Object v2 = xmlConfig.get("data");
        if (!(v2 instanceof DocumentData)) {
            return RenderError.of((String)"Data is missing content for key {0}", (Object[])new Object[]{"xml.data"});
        }
        DocumentData docData = (DocumentData)v2;
        Object v3 = pdfConfig.get("template");
        if (!(v3 instanceof String)) {
            return RenderError.of((String)"Data is missing content for key {0}", (Object[])new Object[]{"pdf.template"});
        }
        String templateName = (String)v3;
        Object v4 = pdfConfig.get("data");
        Map pdfData = v4 instanceof Map ? (map = (Map)v4) : null;
        String xmlId = "Factur-X@" + profile;
        Optional<Document> xmlDoc = this.registry.documents().filter(doc -> doc.id().equals(xmlId)).findAny();
        if (xmlDoc.isEmpty()) {
            return RenderError.of((String)"Registry does not contain document \"{0}\"", (Object[])new Object[]{xmlId});
        }
        Optional<Document> pdfDoc = this.registry.documents().filter(doc -> doc.name().equals(templateName)).findAny();
        if (pdfDoc.isEmpty()) {
            return RenderError.of((String)"Registry does not contain document \"{0}\"", (Object[])new Object[]{templateName});
        }
        if (pdfDoc.get() instanceof WeasyDoc && pdfData != null) {
            pdfData.put("additional_args", List.of("--pdf-variant", "pdf/a-3b"));
        }
        if (!((xmlResult = xmlDoc.get().render(Map.of("data", docData))) instanceof Content)) {
            return xmlResult;
        }
        Content xml = (Content)xmlResult;
        RenderResult pdfResult = pdfDoc.get().render(pdfData);
        if (!(pdfResult instanceof Content)) {
            return pdfResult;
        }
        Content pdf = (Content)pdfResult;
        try {
            String string;
            Document document = pdfDoc.get();
            if (document instanceof FileProcessor) {
                FileProcessor fileProcessor = (FileProcessor)document;
                string = fileProcessor.software();
            } else {
                string = "SRSoftware Document Service";
            }
            String creator = string;
            return new BytesContent(this.combine(pdf, xml, profile, creator, producer, docData), this.mimeType());
        }
        catch (IOException e) {
            return RenderError.of((String)e.getMessage());
        }
    }
}

