/*
 * Decompiled with CFR 0.152.
 */
package de.srsoftware.document.zugferd;

import de.srsoftware.document.zugferd.Basic;
import de.srsoftware.document.zugferd.data.DocumentData;
import de.srsoftware.document.zugferd.data.LineItem;
import de.srsoftware.document.zugferd.tags.ram.Description;
import de.srsoftware.document.zugferd.tags.ram.IncludedSupplyChainTradeLineItem;
import de.srsoftware.document.zugferd.tags.rsm.CrossIndustryInvoice;
import de.srsoftware.tools.Tag;
import java.util.Map;

public class EN16931
extends Basic {
    private static final String EN16931LEVEL = "urn:cen.eu:en16931:2017";

    @Override
    public String id() {
        return "Factur-X@EN16931";
    }

    @Override
    public void intercept(CrossIndustryInvoice document, DocumentData docData) {
        super.intercept(document, docData);
        Map<Integer, IncludedSupplyChainTradeLineItem> map = document.supplyChainTradeTransaction().lineItems();
        for (LineItem lineItem : docData.lineItems()) {
            IncludedSupplyChainTradeLineItem includedSupplyChainTradeLineItem;
            if (lineItem.description() == null || lineItem.description().isBlank() || !((includedSupplyChainTradeLineItem = map.get(lineItem.number())) instanceof IncludedSupplyChainTradeLineItem)) continue;
            IncludedSupplyChainTradeLineItem tag = includedSupplyChainTradeLineItem;
            tag.specifiedTradeProduct().add(new Tag[]{new Description(lineItem.description())});
        }
    }

    @Override
    protected String level() {
        return EN16931LEVEL;
    }
}

