/*
 * Decompiled with CFR 0.152.
 */
package de.srsoftware.document.zugferd;

import de.srsoftware.document.zugferd.Minimum;
import de.srsoftware.document.zugferd.data.CombinedTaxSet;
import de.srsoftware.document.zugferd.data.DocumentData;
import de.srsoftware.document.zugferd.tags.ram.ActualDeliverySupplyChainEvent;
import de.srsoftware.document.zugferd.tags.ram.ApplicableHeaderTradeAgreement;
import de.srsoftware.document.zugferd.tags.ram.ApplicableHeaderTradeDelivery;
import de.srsoftware.document.zugferd.tags.ram.ApplicableHeaderTradeSettlement;
import de.srsoftware.document.zugferd.tags.ram.ApplicableTradeTax;
import de.srsoftware.document.zugferd.tags.ram.BuyerTradeParty;
import de.srsoftware.document.zugferd.tags.ram.ChargeTotalAmount;
import de.srsoftware.document.zugferd.tags.ram.CityName;
import de.srsoftware.document.zugferd.tags.ram.IncludedNote;
import de.srsoftware.document.zugferd.tags.ram.LineOne;
import de.srsoftware.document.zugferd.tags.ram.LineTotalAmount;
import de.srsoftware.document.zugferd.tags.ram.PostalTradeAddress;
import de.srsoftware.document.zugferd.tags.ram.PostcodeCode;
import de.srsoftware.document.zugferd.tags.ram.SellerTradeParty;
import de.srsoftware.document.zugferd.tags.ram.SpecifiedTradePaymentTerms;
import de.srsoftware.document.zugferd.tags.ram.SpecifiedTradeSettlementHeaderMonetarySummation;
import de.srsoftware.document.zugferd.tags.rsm.CrossIndustryInvoice;
import de.srsoftware.document.zugferd.tags.rsm.ExchangedDocument;
import de.srsoftware.document.zugferd.tags.rsm.SupplyChainTradeTransaction;
import de.srsoftware.tools.Tag;

public class BasicWL
extends Minimum {
    private static final String BASIC_WL = "urn:factur-x.eu:1p0:basicwl";

    @Override
    public String id() {
        return "Factur-X@BasicWL";
    }

    @Override
    public void intercept(CrossIndustryInvoice document, DocumentData docData) {
        super.intercept(document, docData);
        ExchangedDocument exchangedDocument = document.exchangedDocument();
        SupplyChainTradeTransaction transaction = document.supplyChainTradeTransaction();
        ApplicableHeaderTradeAgreement agreement = transaction.applicableHeaderTradeAgreement();
        SellerTradeParty seller = agreement.sellerTradeParty();
        BuyerTradeParty buyer = agreement.buyerTradeParty();
        ApplicableHeaderTradeDelivery delivery = transaction.applicableHeaderTradeDelivery();
        ApplicableHeaderTradeSettlement settlement = transaction.applicableHeaderTradeSettlement();
        SpecifiedTradeSettlementHeaderMonetarySummation summation = settlement.specifiedTradeSettlementHeaderMonetarySummation();
        for (String note : docData.notes()) {
            exchangedDocument.add(new Tag[]{new IncludedNote(note)});
        }
        PostalTradeAddress sellerAddress = seller.postalTradeAddress();
        sellerAddress.add(new Tag[]{new PostcodeCode(docData.author().postCode()), new LineOne(docData.author().streetAddress()), new CityName(docData.author().city()), (Tag)sellerAddress.children().getFirst()});
        PostalTradeAddress buyerAddress = new PostalTradeAddress(docData.customer().countryId());
        buyerAddress.add(new Tag[]{new PostcodeCode(docData.customer().postCode()), new LineOne(docData.customer().streetAddress()), new CityName(docData.customer().city()), (Tag)buyerAddress.children().getFirst()});
        buyer.add(new Tag[]{buyerAddress});
        delivery.add(new Tag[]{new ActualDeliverySupplyChainEvent(docData.deliveryDate())});
        for (CombinedTaxSet taxSet : docData.taxSets()) {
            settlement.add(new Tag[]{new ApplicableTradeTax(taxSet)});
        }
        settlement.add(new Tag[]{new SpecifiedTradePaymentTerms(docData)});
        summation.addFirst(new ChargeTotalAmount(docData.chargeTotalAmount())).addFirst((Tag)new LineTotalAmount(docData.taxBasisTotalAmount()));
        settlement.add(new Tag[]{summation});
    }

    @Override
    protected String level() {
        return BASIC_WL;
    }
}

