/*
 * Decompiled with CFR 0.152.
 */
package de.srsoftware.document.zugferd.data;

import de.srsoftware.document.zugferd.data.Author;
import de.srsoftware.document.zugferd.data.CombinedTaxSet;
import de.srsoftware.document.zugferd.data.Currency;
import de.srsoftware.document.zugferd.data.Customer;
import de.srsoftware.document.zugferd.data.LineItem;
import de.srsoftware.document.zugferd.data.LineItemTaxSet;
import de.srsoftware.document.zugferd.data.TypeCode;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.List;

public record DocumentData(String documentNumber, Currency currency, TypeCode typeCode, LocalDate date, Author author, Customer customer, List<String> notes, LocalDate deliveryDate, LocalDate dueDate, String paymentTerms, List<LineItem> lineItems) {
    public long taxBasisTotalAmount() {
        long sum = 0L;
        for (CombinedTaxSet taxSet : this.taxSets()) {
            sum += taxSet.basisAmount();
        }
        return sum;
    }

    public long taxTotalAmount() {
        long sum = 0L;
        for (CombinedTaxSet taxSet : this.taxSets()) {
            sum += taxSet.calculatedAmount();
        }
        return sum;
    }

    public long grandTotalAmount() {
        return this.taxBasisTotalAmount() + this.taxTotalAmount();
    }

    public long duePayableAmount() {
        return this.grandTotalAmount();
    }

    public long chargeTotalAmount() {
        return 0L;
    }

    public List<CombinedTaxSet> taxSets() {
        HashMap<String, CombinedTaxSet> map = new HashMap<String, CombinedTaxSet>();
        for (LineItem lineItem : this.lineItems()) {
            LineItemTaxSet lineTaxSet = lineItem.taxSet();
            CombinedTaxSet combined = map.computeIfAbsent(lineTaxSet.key(), k -> new CombinedTaxSet(0L, lineTaxSet.percent(), lineTaxSet.type()));
            combined.add(lineItem.totalAmount());
        }
        return List.copyOf(map.values());
    }
}

