/*
 * Decompiled with CFR 0.152.
 */
package de.srsoftware.document.zugferd;

import de.srsoftware.document.api.Document;
import de.srsoftware.document.api.RenderError;
import de.srsoftware.document.api.RenderResult;
import de.srsoftware.document.api.StringContent;
import de.srsoftware.document.zugferd.data.DocumentData;
import de.srsoftware.document.zugferd.tags.rsm.CrossIndustryInvoice;
import java.util.Map;

public class Minimum
implements Document {
    private static final String MINIMUM = "urn:factur-x.eu:1p0:minimum";

    public String description() {
        return "Factur-X-genormtes Dokument";
    }

    public String id() {
        return "Factur-X@Minimum";
    }

    public void intercept(CrossIndustryInvoice document, DocumentData docData) {
    }

    protected String level() {
        return MINIMUM;
    }

    public String mimeType() {
        return "application/xml";
    }

    public String name() {
        return "factur-x.xml";
    }

    private RenderResult render(DocumentData docData) {
        CrossIndustryInvoice document = new CrossIndustryInvoice(docData, this.level());
        this.intercept(document, docData);
        return new StringContent("<?xml version='1.0' encoding='UTF-8' ?>\n" + document.toString(2));
    }

    public RenderResult render(Map<String, Object> data) {
        if (!data.containsKey("data")) {
            return RenderError.of((String)"Data does not contain key \"{}\"!", (Object[])new Object[]{"data"});
        }
        Object o = data.get("data");
        if (o instanceof DocumentData) {
            DocumentData documentData = (DocumentData)o;
            return this.render(documentData);
        }
        return RenderError.of((String)"Value for key \"docData\" is invalid: {}", (Object[])new Object[]{o});
    }
}

