/*
 * Decompiled with CFR 0.152.
 */
package de.srsoftware.document.mustang;

import de.srsoftware.document.mustang.XMPSchemaPDFAExtensions;
import de.srsoftware.document.mustang.ZugferdSchema;
import de.srsoftware.tools.Optionals;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.runtime.SwitchBootstraps;
import java.nio.charset.StandardCharsets;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.transform.TransformerException;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.pdfwriter.compress.CompressParameters;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentCatalog;
import org.apache.pdfbox.pdmodel.PDDocumentInformation;
import org.apache.pdfbox.pdmodel.PDDocumentNameDictionary;
import org.apache.pdfbox.pdmodel.PDEmbeddedFilesNameTreeNode;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.common.PDMetadata;
import org.apache.pdfbox.pdmodel.common.filespecification.PDComplexFileSpecification;
import org.apache.pdfbox.pdmodel.common.filespecification.PDEmbeddedFile;
import org.apache.pdfbox.pdmodel.documentinterchange.logicalstructure.PDMarkInfo;
import org.apache.pdfbox.pdmodel.documentinterchange.logicalstructure.PDStructureTreeRoot;
import org.apache.pdfbox.pdmodel.font.PDCIDFontType2;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType0Font;
import org.apache.pdfbox.pdmodel.graphics.color.PDOutputIntent;
import org.apache.xmpbox.XMPMetadata;
import org.apache.xmpbox.schema.AdobePDFSchema;
import org.apache.xmpbox.schema.DublinCoreSchema;
import org.apache.xmpbox.schema.PDFAIdentificationSchema;
import org.apache.xmpbox.schema.XMPBasicSchema;
import org.apache.xmpbox.schema.XMPSchema;
import org.apache.xmpbox.type.AbstractField;
import org.apache.xmpbox.type.ArrayProperty;
import org.apache.xmpbox.type.BadFieldValueException;
import org.apache.xmpbox.xml.DomXmpParser;
import org.apache.xmpbox.xml.XmpParsingException;
import org.apache.xmpbox.xml.XmpSerializer;

public class A3Exporter {
    private String creator = "mustangproject";
    private final PDDocument doc;
    private boolean documentPrepared = false;
    private boolean fileAttached = false;
    private String profile = null;
    private String producer = "mustangproject";
    private String author;
    private String subject;
    private String title;
    private byte[] xml;

    public A3Exporter(PDDocument doc) {
        this.doc = doc;
    }

    private void addSrgbOutputIntend() throws IOException {
        if (!this.doc.getDocumentCatalog().getOutputIntents().isEmpty()) {
            return;
        }
        InputStream colorProfile = Thread.currentThread().getContextClassLoader().getResourceAsStream("sRGB.icc");
        if (colorProfile != null) {
            PDOutputIntent intent = new PDOutputIntent(this.doc, colorProfile);
            intent.setInfo("sRGB IEC61966-2.1");
            intent.setOutputCondition("sRGB IEC61966-2.1");
            intent.setOutputConditionIdentifier("sRGB IEC61966-2.1");
            intent.setRegistryName("http://www.color.org");
            this.doc.getDocumentCatalog().addOutputIntent(intent);
        }
    }

    private void addStructureTreeRoot() {
        PDDocumentCatalog catalog = this.doc.getDocumentCatalog();
        if (catalog.getStructureTreeRoot() == null) {
            catalog.setStructureTreeRoot(new PDStructureTreeRoot());
        }
    }

    private void addXMP(XMPMetadata metadata) {
        metadata.addSchema((XMPSchema)new ZugferdSchema(metadata, this.getXMPName(this.profile), this.getFilenameForVersion(this.profile)));
        metadata.addSchema((XMPSchema)new XMPSchemaPDFAExtensions(metadata));
    }

    public void close() throws IOException {
        if (this.doc != null) {
            this.doc.close();
        }
    }

    public byte[] export() throws IOException {
        if (!this.documentPrepared) {
            this.prepareDocument();
        }
        if (!this.fileAttached) {
            throw new IOException("File must be attached (usually with setTransaction) before performing this operation");
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        this.doc.save((OutputStream)bos, CompressParameters.NO_COMPRESSION);
        this.close();
        return bos.toByteArray();
    }

    private String getFilenameForVersion(String profile) {
        if (profile.equals("XRECHNUNG")) {
            return "xrechnung.xml";
        }
        return "factur-x.xml";
    }

    private XMPMetadata getXmpMetadata() throws IOException {
        PDMetadata meta = this.doc.getDocumentCatalog().getMetadata();
        if (meta != null && meta.getLength() > 0) {
            try {
                return new DomXmpParser().parse(meta.toByteArray());
            }
            catch (XmpParsingException e) {
                throw new IOException(e);
            }
        }
        return XMPMetadata.createXMPMetadata();
    }

    private String getXMPName(String profile) {
        return switch (profile) {
            case "BASICWL" -> "BASIC WL";
            case "EN16931" -> "EN 16931";
            default -> profile;
        };
    }

    private void pdfAttachGenericFile(PDDocument doc, String filename, String relationship, byte[] data) throws IOException {
        this.fileAttached = true;
        PDComplexFileSpecification fileSpec = new PDComplexFileSpecification();
        fileSpec.setFile(filename);
        COSDictionary dict = fileSpec.getCOSObject();
        dict.setName("AFRelationship", relationship);
        dict.setString("UF", filename);
        dict.setString("Desc", "Invoice metadata conforming to ZUGFeRD standard (http://www.ferd-net.de/front_content.php?idcat=231&lang=4)");
        PDEmbeddedFile embeddedFile = new PDEmbeddedFile(doc, (InputStream)new ByteArrayInputStream(data));
        embeddedFile.setSubtype("text/xml");
        embeddedFile.setSize(data.length);
        embeddedFile.setCreationDate((Calendar)new GregorianCalendar());
        embeddedFile.setModDate(Calendar.getInstance());
        fileSpec.setEmbeddedFile(embeddedFile);
        dict = fileSpec.getCOSObject();
        COSDictionary efDict = (COSDictionary)dict.getDictionaryObject(COSName.EF);
        efDict.setItem(COSName.UF, efDict.getItem(COSName.F));
        PDDocumentNameDictionary names = new PDDocumentNameDictionary(doc.getDocumentCatalog());
        PDEmbeddedFilesNameTreeNode embeddedFiles = names.getEmbeddedFiles();
        if (embeddedFiles == null) {
            embeddedFiles = new PDEmbeddedFilesNameTreeNode();
        }
        HashMap<String, PDComplexFileSpecification> namesMap = new HashMap<String, PDComplexFileSpecification>();
        Map oldNamesMap = embeddedFiles.getNames();
        if (oldNamesMap != null) {
            for (String key : oldNamesMap.keySet()) {
                namesMap.put(key, (PDComplexFileSpecification)oldNamesMap.get(key));
            }
        }
        namesMap.put(filename, fileSpec);
        embeddedFiles.setNames(namesMap);
        names.setEmbeddedFiles(embeddedFiles);
        doc.getDocumentCatalog().setNames(names);
        COSBase cOSBase = doc.getDocumentCatalog().getCOSObject().getItem("AF");
        int n = 0;
        block6: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{COSArray.class, COSObject.class}, (Object)cOSBase, n)) {
                case -1: {
                    COSArray cosArray = new COSArray();
                    cosArray.add((COSObjectable)fileSpec);
                    doc.getDocumentCatalog().getCOSObject().setItem("AF", (COSBase)cosArray);
                    break block6;
                }
                case 0: {
                    COSArray cosArray = (COSArray)cOSBase;
                    cosArray.add((COSObjectable)fileSpec);
                    doc.getDocumentCatalog().getCOSObject().setItem("AF", (COSBase)cosArray);
                    break block6;
                }
                case 1: {
                    COSObject cosObject = (COSObject)cOSBase;
                    COSBase cOSBase2 = cosObject.getObject();
                    if (!(cOSBase2 instanceof COSArray)) {
                        n = 2;
                        continue block6;
                    }
                    COSArray cosArray = (COSArray)cOSBase2;
                    cosArray.add((COSObjectable)fileSpec);
                    break block6;
                }
                default: {
                    throw new IOException("Unexpected object type for PDFDocument/Catalog/COSDictionary/Item(AF)");
                }
            }
            break;
        }
    }

    private void prepare() throws IOException {
        this.prepareDocument();
        String relationship = Set.of("MINIMUM", "BASICWL").contains(this.profile.toUpperCase()) ? "Data" : "Alternative";
        this.pdfAttachGenericFile(this.doc, this.getFilenameForVersion(this.profile), relationship, this.xml);
    }

    private void prepareDocument() throws IOException {
        PDDocumentCatalog cat = this.doc.getDocumentCatalog();
        PDMetadata metadata = new PDMetadata(this.doc);
        cat.setMetadata(metadata);
        this.removeCidSet(this.doc);
        XMPMetadata xmp = this.getXmpMetadata();
        this.writeAdobePDFSchema(xmp);
        this.writePDFAIdentificationSchema(xmp);
        this.writeDublinCoreSchema(xmp);
        this.writeXMLBasicSchema(xmp);
        this.writeDocumentInformation();
        this.addSrgbOutputIntend();
        this.setMarked();
        this.addStructureTreeRoot();
        this.addXMP(xmp);
        try {
            metadata.importXMPMetadata(this.serializeXmpMetadata(xmp));
        }
        catch (TransformerException e) {
            throw new RuntimeException("Could not export XmpMetadata", e);
        }
        this.documentPrepared = true;
    }

    private void removeCidSet(PDDocument doc) throws IOException {
        COSName cidSet = COSName.getPDFName((String)"CIDSet");
        COSName resources = COSName.getPDFName((String)"Resources");
        for (PDPage object : doc.getPages()) {
            if (!(object instanceof PDPage)) continue;
            PDPage page = object;
            PDResources res = page.getResources();
            for (COSName xObjectName : res.getXObjectNames()) {
                COSDictionary dictionary = res.getXObject(xObjectName).getCOSObject().getCOSDictionary(resources);
                if (dictionary == null) continue;
                this.removeCIDSetFromPDResources(cidSet, new PDResources(dictionary));
            }
            this.removeCIDSetFromPDResources(cidSet, res);
        }
    }

    private void removeCIDSetFromPDResources(COSName cidSet, PDResources res) throws IOException {
        for (COSName fontName : res.getFontNames()) {
            PDType0Font typedFont;
            PDFont pdFont = res.getFont(fontName);
            if (!(pdFont instanceof PDType0Font) || !((typedFont = (PDType0Font)pdFont).getDescendantFont() instanceof PDCIDFontType2)) continue;
            pdFont.getFontDescriptor().getCOSObject().removeItem(cidSet);
        }
    }

    private byte[] serializeXmpMetadata(XMPMetadata xmpMetadata) throws TransformerException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        new XmpSerializer().serialize(xmpMetadata, (OutputStream)buffer, true);
        return buffer.toByteArray();
    }

    public A3Exporter setAuthor(String newValue) {
        this.author = newValue;
        return this;
    }

    public A3Exporter setCreator(String newValue) {
        this.creator = newValue;
        return this;
    }

    private void setMarked() {
        PDDocumentCatalog catalog = this.doc.getDocumentCatalog();
        if (catalog.getMarkInfo() == null) {
            catalog.setMarkInfo(new PDMarkInfo(this.doc.getPages().getCOSObject()));
        }
        catalog.getMarkInfo().setMarked(true);
    }

    public A3Exporter setProducer(String newValue) {
        this.producer = newValue;
        return this;
    }

    public A3Exporter setProfile(String newValue) {
        this.profile = newValue;
        return this;
    }

    public A3Exporter setTitle(String newValue) {
        this.title = newValue;
        return this;
    }

    public A3Exporter setXML(byte[] zugferdData) throws IOException {
        String zf = new String(zugferdData, StandardCharsets.UTF_8);
        if (!(zf.contains("rsm:CrossIndustry") || zf.contains("rsm:SCRDMCCBDACIOMessageStructure") || zf.contains("SCRDMCCBDACIDAMessageStructure"))) {
            throw new RuntimeException("ZUGFeRD XML does not contain <rsm:CrossIndustry, <rsm:SCRDMCCBDACIOMessageStructure or SCRDMCCBDACIDAMessageStructure and can thus not be valid");
        }
        this.xml = zugferdData;
        this.prepare();
        return this;
    }

    private void writePDFAIdentificationSchema(XMPMetadata xmp) {
        try {
            PDFAIdentificationSchema pdfaid = xmp.getPDFAIdentificationSchema();
            if (pdfaid != null) {
                xmp.removeSchema((XMPSchema)pdfaid);
            }
            pdfaid = xmp.createAndAddPDFAIdentificationSchema();
            pdfaid.setConformance("U");
            pdfaid.setPart(Integer.valueOf(3));
        }
        catch (BadFieldValueException ex) {
            throw new Error(ex);
        }
    }

    private void writeDocumentInformation() {
        PDDocumentInformation info = this.doc.getDocumentInformation();
        info.setCreationDate(Calendar.getInstance());
        info.setModificationDate(Calendar.getInstance());
        info.setAuthor(this.author);
        info.setProducer(this.producer);
        info.setCreator(this.creator);
        info.setTitle(this.title);
        info.setSubject(this.subject);
    }

    private void writeXMLBasicSchema(XMPMetadata xmp) {
        XMPBasicSchema xsb = xmp.getXMPBasicSchema();
        if (xsb != null) {
            xmp.removeSchema((XMPSchema)xsb);
        }
        xsb = xmp.createAndAddXMPBasicSchema();
        xsb.setCreatorTool(this.creator);
        xsb.setCreateDate(Calendar.getInstance());
    }

    private void writeDublinCoreSchema(XMPMetadata xmp) {
        ArrayProperty titleProperty;
        DublinCoreSchema dcSchema = xmp.getDublinCoreSchema();
        if (dcSchema != null) {
            xmp.removeSchema((XMPSchema)dcSchema);
        }
        if ((dcSchema = xmp.createAndAddDublinCoreSchema()).getFormat() == null) {
            dcSchema.setFormat("application/pdf");
        }
        if (this.creator != null) {
            dcSchema.addCreator(this.creator);
            dcSchema.addDate(Calendar.getInstance());
        }
        if ((titleProperty = dcSchema.getTitleProperty()) != null) {
            if (Optionals.isSet((Object)this.title)) {
                dcSchema.removeProperty((AbstractField)titleProperty);
                dcSchema.setTitle(this.title);
            } else if (titleProperty.getElementsAsString().stream().anyMatch("Untitled"::equalsIgnoreCase)) {
                dcSchema.removeProperty((AbstractField)titleProperty);
            }
        } else if (Optionals.isSet((Object)this.title)) {
            dcSchema.setTitle(this.title);
        }
    }

    private void writeAdobePDFSchema(XMPMetadata xmp) {
        AdobePDFSchema pdf = xmp.getAdobePDFSchema();
        if (pdf != null) {
            xmp.removeSchema((XMPSchema)pdf);
        }
        pdf = xmp.createAndAddAdobePDFSchema();
        pdf.setProducer(this.producer);
    }
}

