/* © SRSoftware 2025 */
package de.srsoftware.tools;


/**
 * this resides in package de.srsoftware.tools, as it overrides the indent method, which is package-private
 */
public class Inline extends Tag {

	/**
	 * neue Instanz
	 * @param type Tag-Typ der zu erzeugenden Instanz
	 */
	public Inline(String type) {
		super(type);
	}

	/**
	 * Betrag, der eingesetzt werden soll. Wird durch 100 geteilt.
	 * @param amount Betrag, der eingesetzt werden soll. Wird durch 100 geteilt.
	 * @return dieses Objekt
	 */
	public Inline content(long amount){
		super.content(""+amount/100d);
		return this;
	}

	@Override
	protected void indent(StringBuilder sb, int indent, int currentIndentation) {
		var type = this.type();
		boolean textType = type == null || type.isBlank();
		if (!textType) {
			sb.append(" ".repeat(currentIndentation)).append("<").append(type);
			for (var entry : entrySet()) {
				sb.append(" ").append(entry.getKey());
				var value = entry.getValue();
				if (value != null) sb.append("=\"").append(entry.getValue()).append("\"");
			}
		}
		if (children().isEmpty()) {
			sb.append(" />\n");
		} else {
			if (!textType) sb.append(">");
			for (Tag child : children()) sb.append(child.toString());
			if (!textType) sb.append("</").append(type).append(">\n");
		}
	}
}
