/* © SRSoftware 2025 */
package de.srsoftware.document.zugferd.tags.udt;

import de.srsoftware.document.zugferd.tags.base.Udt;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;

/**
 * Eine Datum-Repräsentation
 * Datentyp: extension (xs:string)
 * Kardinalität: 1 … 1
 */
public class DateTimeString extends Udt {
	private static final String FORMAT = "format";
	private static final int FORMAT_102 = 102;
	private static final DateTimeFormatter PATTERN_102 = DateTimeFormatter.ofPattern("yyyyMMdd");

	/**
	 * Erzeugt ein neues DateTimeString-Tag mit dem gegebenen Datum als Content
	 * @param date das Datum, welches als Content verwendet werden soll
	 */
	public DateTimeString(LocalDate date) {
		super("DateTimeString");
		attr(FORMAT,FORMAT_102);
		content(date.format(PATTERN_102));
	}
}
