/* © SRSoftware 2025 */
package de.srsoftware.document.zugferd.tags.rsm;

import de.srsoftware.document.zugferd.data.DocumentData;
import de.srsoftware.document.zugferd.tags.base.Rsm;
import de.srsoftware.document.zugferd.tags.ram.ApplicableHeaderTradeAgreement;
import de.srsoftware.document.zugferd.tags.ram.ApplicableHeaderTradeDelivery;
import de.srsoftware.document.zugferd.tags.ram.ApplicableHeaderTradeSettlement;
import de.srsoftware.document.zugferd.tags.ram.IncludedSupplyChainTradeLineItem;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * Gruppierung der Informationen zum Geschäft
 * Datentyp: ram:SupplyChainTradeTransactionType
 * Kardinalität: 1 … 1
 */
public class SupplyChainTradeTransaction extends Rsm {
	/** internes Tag **/ private final ApplicableHeaderTradeAgreement applicableHeaderTradeAgreement;
	/** internes Tag **/ private final ApplicableHeaderTradeDelivery applicableHeaderTradeDelivery;
	/** internes Tag **/ private final ApplicableHeaderTradeSettlement applicableHeaderTradeSettlement;

	/**
	 * neues Tag
	 * @param docData Dokumenten-Daten
	 */
	public SupplyChainTradeTransaction(DocumentData docData) {
		super("SupplyChainTradeTransaction");
		// +@Basic: IncludedSupplyChainTradeLineItem
		add(applicableHeaderTradeAgreement = new ApplicableHeaderTradeAgreement(docData));
		add(applicableHeaderTradeDelivery = new ApplicableHeaderTradeDelivery());
		add(applicableHeaderTradeSettlement = new ApplicableHeaderTradeSettlement(docData));
	}

	/**
	 * liefert das ApplicableHeaderTradeAgreement-Tag zur Modifikation zurück
	 * @return das ApplicableHeaderTradeAgreement-Tag
	 */
	public ApplicableHeaderTradeAgreement applicableHeaderTradeAgreement(){
		return  applicableHeaderTradeAgreement;
	};

	/**
	 * liefert das ApplicableHeaderTradeDelivery-Tag zur Modifikation zurück
	 * @return das ApplicableHeaderTradeDelivery-Tag
	 */
	public ApplicableHeaderTradeDelivery applicableHeaderTradeDelivery(){
		return applicableHeaderTradeDelivery;
	};

	/**
	 * liefert das ApplicableHeaderTradeSettlement-Tag zur Modifikation zurück
	 * @return das ApplicableHeaderTradeSettlement-Tag
	 */
	public ApplicableHeaderTradeSettlement applicableHeaderTradeSettlement(){
		return applicableHeaderTradeSettlement;
	};

	/**
	 * get the line items
	 * @return map from line item ids to line items
	 */
	public Map<Integer,IncludedSupplyChainTradeLineItem> lineItems(){
		return children().stream()
				.filter(child -> child instanceof IncludedSupplyChainTradeLineItem)
				.map(IncludedSupplyChainTradeLineItem.class::cast)
				.collect(Collectors.toMap(li -> li.associatedDocumentLineDocument().lineID().value(),li -> li));
	}
}
