/* © SRSoftware 2025 */
package de.srsoftware.document.zugferd.tags.rsm;

import de.srsoftware.document.zugferd.tags.base.Rsm;
import de.srsoftware.document.zugferd.tags.ram.GuidelineSpecifiedDocumentContextParameter;

/**
 * Datentyp: ram:ExchangedDocumentContextType
 *  Kardinalität: 1 .. 1
 *  Anwendung: Eine Gruppe von betriebswirtschaftlichen Begriffen, die Informationen über den Geschäftsprozess und für das Rechnungsdokument geltende Regeln enthält
 */
public class ExchangedDocumentContext extends Rsm {
	/**
	 * neues Tag
	 * @param level einzusetzende Compliance-Kennung
	 */
	public ExchangedDocumentContext(String level) {
		super("ExchangedDocumentContext");
		// optional@Minimum, BasicWL, Basic, EN16931: BusinessProcessSpecifiedDocumentContextParameter
		add(new GuidelineSpecifiedDocumentContextParameter(level));
	}
}
