/* © SRSoftware 2025 */
package de.srsoftware.document.zugferd.tags.rsm;

import de.srsoftware.document.zugferd.data.DocumentData;
import de.srsoftware.document.zugferd.tags.base.Rsm;
import de.srsoftware.document.zugferd.tags.ram.ID;
import de.srsoftware.document.zugferd.tags.ram.IssueDateTime;
import de.srsoftware.document.zugferd.tags.ram.TypeCode;

/**
 * Datentyp: ram:ExchangedDocumentType
 * Kardinalität: 1 .. 1
 */
public class ExchangedDocument extends Rsm {
	/**
	 * neues Tag
	 * @param docData einzusetzende Daten
	 */
	public ExchangedDocument(DocumentData docData) {
		super("ExchangedDocument");
		add(new ID(docData.documentNumber()));
		add(new TypeCode(docData.typeCode()));
		add(new IssueDateTime(docData.date()));
		// optional@BasicWL,Basic: IncludedNote (@see de.srsoftware.document.zugferd.BasicWL#BasicWL(DocumentData))
	}
}
