/* © SRSoftware 2025 */
package de.srsoftware.document.zugferd.tags.rsm;


import de.srsoftware.document.zugferd.data.DocumentData;
import de.srsoftware.document.zugferd.tags.base.Rsm;

/**
 * XML-Wurzelelement
 */
public class CrossIndustryInvoice extends Rsm {
	private static final String SCHEMA_INSTANCE = "http://www.w3.org/2001/XMLSchema-instance";
	private static final String QDT = "xmlns:qdt";
	private static final String QDT100 = "urn:un:unece:uncefact:data:standard:QualifiedDataType:100";
	private static final String RAM = "xmlns:ram";
	private static final String RAM100 = "urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100";
	private static final String RSM = "xmlns:rsm";
	private static final String RSM100 = "urn:un:unece:uncefact:data:standard:CrossIndustryInvoice:100";
	private static final String UDT = "xmlns:udt";
	private static final String UDT100 = "urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100";
	private static final String XSI = "xmlns:xsi";
	/** internes Tag **/ private final ExchangedDocument exchangedDocument;
	/** internes Tag **/ private final SupplyChainTradeTransaction supplyChainTradeTransaction;

	/**
	 * neues XML erzeugen
	 * @param docData anzuwendende Daten
	 * @param level Compliance-Level des XML-Dokuments
	 */
	public CrossIndustryInvoice(DocumentData docData, String level) {
		super("CrossIndustryInvoice");
		attr(XSI,SCHEMA_INSTANCE);
		attr(QDT,QDT100);
		attr(UDT,UDT100);
		attr(RSM,RSM100);
		attr(RAM,RAM100);

		add(new ExchangedDocumentContext(level));
		add(exchangedDocument = new ExchangedDocument(docData));
		add(supplyChainTradeTransaction = new SupplyChainTradeTransaction(docData));

	}

	/**
	 * gibt das ExchangedDocument-Tag zur Modifikation zurück
	 * @return das ExchangedDocument-Tag
	 */
	public ExchangedDocument exchangedDocument() {
		return exchangedDocument;
	}

	/**
	 * gibt das SupplyChainTradeTransaction-Tag zur Modifikation zurück
	 * @return das SupplyChainTradeTransaction-Tag
	 */
	public SupplyChainTradeTransaction supplyChainTradeTransaction(){
		return supplyChainTradeTransaction;
	}
}
