/* © SRSoftware 2025 */
package de.srsoftware.document.zugferd.tags.ram;

import de.srsoftware.document.zugferd.data.Currency;
import de.srsoftware.document.zugferd.tags.base.InlineRam;

/**
 * Gesamtbetrag der Rechnungsumsatzsteuer
 * Datentyp: udt:AmountType
 * Hinweis: Der Gesamtbetrag der Rechnungsumsatzsteuer ist die Summe aller Beträge
 *          für die einzelnen Umsatzsteuerkategorien.
 * Kardinalität: 0 … 1
 * Anwendung: Der Gesamtbetrag der Umsatzsteuer für die Rechnung
 * Geschäftsregeln: BR-CO-14, BR-CO-15
 */
public class TaxTotalAmount extends InlineRam {
	/**
	 * neues Tag
	 * @param amount betrag
	 * @param currency Währung
	 */
	public TaxTotalAmount(long amount, Currency currency) {
		super("TaxTotalAmount");
		attr("currencyID",currency.toString());
		content(amount);
	}
}
