/* © SRSoftware 2025 */
package de.srsoftware.document.zugferd.tags.ram;

import de.srsoftware.document.zugferd.tags.base.InlineRam;

/**
 * Datentyp: udt:AmountType
 * Hinweis: Der Rechnungsgesamtbetrag ohne Umsatzsteuer ist die Summe der Rechnungspositions-Nettobeträge abzüglich der Summe der Zuschläge auf Dokumentenebene zuzüglich der Summe der Abschläge der Dokumentenebene.
 * Kardinalität: 1 .. 1
 * Anwendung: Die Gesamtsumme der Rechnung ohne Umsatzsteuer
 * Geschäftsregeln: BR-13, BR-CO-13, BR-CO-15
 */
public class TaxBasisTotalAmount extends InlineRam {
	/**
	 * neues Tag
	 * @param amount einzusetzender Betrag
	 */
	public TaxBasisTotalAmount(long amount) {
		super("TaxBasisTotalAmount");
		content(amount);
	}
}
