/* © SRSoftware 2025 */
package de.srsoftware.document.zugferd.tags.ram;

import de.srsoftware.document.zugferd.data.DocumentData;
import de.srsoftware.document.zugferd.tags.base.Ram;

/**
 * GESAMTSUMMEN AUF DOKUMENTENEBENE
 * Datentyp: ram:TradeSettlementHeaderMonetarySummationType
 * Kardinalität: 1 … 1
 * Anwendung: Eine Gruppe von betriebswirtschaftlichen Begriffen, die die monetären Gesamtsummen der Rechnung enthält
 */
public class SpecifiedTradeSettlementHeaderMonetarySummation extends Ram {

	/**
	 * neues Tag
	 * @param docData Dokumenten-Daten
	 */
	public SpecifiedTradeSettlementHeaderMonetarySummation(DocumentData docData) {
		super("SpecifiedTradeSettlementHeaderMonetarySummation");
		// +@BasicWL: LineTotalAmount
		// optional@BasicWL, Basic, EN16931: ChargeTotalAmount
		// optional@BasicWL, Basic, EN16931: AllowanceTotalAmount
		add(new TaxBasisTotalAmount(docData.taxBasisTotalAmount()));
		add(new TaxTotalAmount(docData.taxTotalAmount(),docData.currency())); // optional@Minimum
		// optional@EN16931: RoundingAmount
		add(new GrandTotalAmount(docData.grandTotalAmount()));
		// optional@BasicWL, Basic, EN16931: TotalPrepaidAmount
		add(new DuePayableAmount(docData.duePayableAmount()));
	}
}
