/* © SRSoftware 2025 */
package de.srsoftware.document.zugferd.tags.ram;

import static de.srsoftware.tools.Optionals.isSet;

import de.srsoftware.document.zugferd.data.LineItem;
import de.srsoftware.document.zugferd.tags.base.Ram;

/**
 * Datentyp: ram:TradeProductType
 * Kardinalität: 1 .. 1
 * Anwendung: Eine Gruppe von betriebswirtschaftlichen Begriffen, die Informationen über die in Rechnung gestellten Waren und Dienstleistungen enthält
 */
public class SpecifiedTradeProduct extends Ram {
	/**
	 * neues Tag
	 * @param lineItem Daten für die Rechnungsposition
	 */
	public SpecifiedTradeProduct(LineItem lineItem) {
		super("SpecifiedTradeProduct");
		if (isSet(lineItem.id())) add(new GlobalID(lineItem.id())); // optional
		// optional@EN16931: SellerAssignedID
		// optional@EN16931: BuyerAssignedID
		add(new Name(lineItem.name()));
		// optional@EN16931: Description
		// optional@EN16931: ApplicableProductCharacteristic
		// optional@EN16931: DesignatedProductClassification
		// optional@EN16931: OriginTradeCountry
	}
}
