/* © SRSoftware 2025 */
package de.srsoftware.document.zugferd.tags.ram;

import de.srsoftware.document.zugferd.data.DocumentData;
import de.srsoftware.document.zugferd.tags.base.Ram;

/**
 * Detailinformationen zu Zahlungsbedingungen
 * Datentyp: ram:TradePaymentTermsType
 * Kardinalität: 0 … 1
 */
public class SpecifiedTradePaymentTerms extends Ram {
	/**
	 * neues Tag
	 * @param docData Dokumenten-Daten
	 */
	public SpecifiedTradePaymentTerms(DocumentData docData) {
		super("SpecifiedTradePaymentTerms");
		var paymentTerms = docData.paymentTerms();
		if (paymentTerms != null) add(new Description(paymentTerms));
		var dueDate = docData.dueDate();
		if (dueDate != null) add(new DueDateDateTime(dueDate));
	}
}
