/* © SRSoftware 2025 */
package de.srsoftware.document.zugferd.tags.ram;

import de.srsoftware.document.zugferd.data.LineItem;
import de.srsoftware.document.zugferd.tags.base.Ram;

/**
 * Datentyp: ram:LineTradeSettlementType
 * Kardinalität: 1 .. 1
 * Anwendung: Gruppierung von Angaben zur Abrechnung auf Positionsebene
 */
public class SpecifiedLineTradeSettlement extends Ram {

	/**
	 * neues Tag
	 * @param lineItem Daten für die Rechnungsposition
	 */
	 public SpecifiedLineTradeSettlement(LineItem lineItem) {
		super("SpecifiedLineTradeSettlement");
		add(new ApplicableTradeTax(lineItem.taxSet()));
		// optional@Basic: BillingSpecifiedPeriod
		// optional@Basic: SpecifiedTradeAllowanceCharge
		add(new SpecifiedTradeSettlementLineMonetarySummation(lineItem.totalAmount()));
		// optional@EN16931: AdditionalReferencedDocument
		// optional@EN16931: ReceivableSpecifiedTradeAccountingAccount

	}
}
