/* © SRSoftware 2025 */
package de.srsoftware.document.zugferd.tags.ram;

import de.srsoftware.document.zugferd.data.LineItem;
import de.srsoftware.document.zugferd.tags.base.Ram;

/**
 * Datentyp: ram:LineTradeDeliveryType
 * Kardinalität: 1 .. 1
 * Anwendung: Gruppierung von Lieferangaben aus Positionsebene
 */
public class SpecifiedLineTradeDelivery extends Ram {
	/**
	 * neues Tag
	 * @param lineItem Daten für die Rechnungsposition
	 */
	public SpecifiedLineTradeDelivery(LineItem lineItem) {
		super("SpecifiedLineTradeDelivery");
		add(new BilledQuantity(lineItem.amount(),lineItem.unit()));
	}
}
