/* © SRSoftware 2025 */
package de.srsoftware.document.zugferd.tags.ram;

import de.srsoftware.document.zugferd.data.LineItem;
import de.srsoftware.document.zugferd.tags.base.Ram;

/**
 * Datentyp: ram:LineTradeAgreementType
 * Synonym: Gruppierung der Vertragsangaben auf Positionsebene
 * Kardinalität: 1 .. 1
 * Anwendung: Eine Gruppe von betriebswirtschaftlichen Begriffen, die Informationen über den Preis für die in der betreffenden
 *            Rechnungsposition in Rechnung gestellten Waren und Dienstleistungen enthält
 */
public class SpecifiedLineTradeAgreement extends Ram {
	/**
	 * neues Tag
	 * @param lineItem Daten für die Rechnungs-Position
	 */
	public SpecifiedLineTradeAgreement(LineItem lineItem) {
		super("SpecifiedLineTradeAgreement");
		// optional@EN16931: BuyerOrderReferencedDocument
		// optional@Basic, EN16931: GrossPriceProductTradePrice
		add(new NetPriceProductTradePrice(lineItem.unitPrice()));
	}
}
