/* © SRSoftware 2025 */
package de.srsoftware.document.zugferd.tags.ram;

import de.srsoftware.document.zugferd.data.Author;
import de.srsoftware.document.zugferd.tags.base.Ram;

/**
 * Verkäufer-Daten
 * Datentyp: ram:TradePartyType
 * Kardinalität: 1 … 1
 * Anwendung: Eine Gruppe von betriebswirtschaftlichen Begriffen, die Informationen über den Verkäufer enthält
 */
public class SellerTradeParty extends Ram {
	/** internes Tag **/ private final PostalTradeAddress postalTradeAddress;

	/**
	 * neues Tag
	 * @param author Verkäfer-Daten, die eingesetzt werden
	 */
	public SellerTradeParty(Author author) {
		super("SellerTradeParty");
		// optional@BasicWL, Basic, EN16931: ID
		// optional@BasicWL, Basic, EN16931: GlobalID
		add(new Name(author.name()));
		// optional@EN16931: Description
		// optional@Minimum, BasicWL, Basic: SpecifiedLegalOrganization
		// optional@EN16931: DefinedTradeContact
		add(postalTradeAddress = new PostalTradeAddress(author.countryId()));
		// optional@BasicWL, Basic: URIUniversalCommunication
		add(new SpecifiedTaxRegistration(author.taxId())); // optional@Minimum, BasicWL, Basic

	}

	/**
	 * gibt die Postadresse zum Zwecke der Modifikation zurück
	 * @return das PostalTradeAddress-Tag
	 */
	public PostalTradeAddress postalTradeAddress() {
		return postalTradeAddress;
	}
}
