/* © SRSoftware 2025 */
package de.srsoftware.document.zugferd.tags.ram;

import de.srsoftware.document.zugferd.data.CountryCode;
import de.srsoftware.document.zugferd.tags.base.Ram;

/**
 * Datentyp: ram:TradeAddressType
 * Hinweis: Um den rechtlichen Anforderungen zu entsprechen,
 *          muss eine ausreichende Anzahl an Komponenten der Anschrift eingegeben werden.
 * Kardinalität: 1 … 1
 * Anwendung: Eine Gruppe von betriebswirtschaftlichen Begriffen, die Informationen über die Anschrift enthält
 */
public class PostalTradeAddress extends Ram {
	/**
	 * neues Tag
	 * @param code zu verwendender Länder-Code
	 */
	public PostalTradeAddress(CountryCode code) {
		super("PostalTradeAddress");
		// optional@BasicWL, Basic, EN16931: PostcodeCode
		// optional@BasicWL, Basic, EN16931: LineOne
		// optional@BasicWL, Basic, EN16931: LineTwo
		// optional@BasicWL, Basic, EN16931: LineThree
		// optional@BasicWL, Basic, EN16931: CityName
		add(new CountryID(code));
		// optional@BasicWL, Basic, EN16931: CountrySubDivisionName
	}
}
