/* © SRSoftware 2025 */
package de.srsoftware.document.zugferd.tags.ram;

import de.srsoftware.document.zugferd.tags.base.Ram;
import de.srsoftware.document.zugferd.tags.udt.DateTimeString;
import java.time.LocalDate;


/**
 * Datentyp: udt:DateTimeType
 * Hinweis: In Deutschland ist das Liefer- und Leistungsdatum eine Pflichtangabe auf Rechnungen.
 *          Diese kann auch auf Positionsebene angegeben werden, muss aber in jedem Fall hier angegeben sein.
 * Kardinalität: 1 … 1
 * Anwendung: Das Datum, an dem die Lieferung erfolgt.
 */
public class OccurrenceDateTime extends Ram {

	/**
	 * neues Tag
	 * @param date einzusetzende Zeit
	 */
	public OccurrenceDateTime(LocalDate date) {
		super("OccurrenceDateTime");
		add(new DateTimeString(date));
	}
}
