/* © SRSoftware 2025 */
package de.srsoftware.document.zugferd.tags.ram;

import de.srsoftware.document.zugferd.tags.base.Ram;

/**
 * Datentyp: ram:TradePriceType
 * Hinweis: Im Nettopreis sind alle Zu- und Abschläge enthalten, jedoch nicht die Umsatzsteuer.
 * Kardinalität: 1 .. 1
 */
public class NetPriceProductTradePrice extends Ram {
	/**
	 * neues Tag
	 * @param unitPrice einzusetzender Betrag
	 */
	public NetPriceProductTradePrice(long unitPrice) {
		super("NetPriceProductTradePrice");
		add(new ChargeAmount(unitPrice));
		// optional@Basic, EN16931: BasisQuantity
	}
}
