/* © SRSoftware 2025 */
package de.srsoftware.document.zugferd.tags.ram;

import de.srsoftware.document.zugferd.tags.base.InlineRam;

/**
 * Datentyp: udt:IDType
 * Synonym: Positionsnummer
 * Kardinalität: 1 .. 1
 * Anwendung: Eine eindeutige Kennung für die betreffende Position innerhalb der Rechnung
 * Geschäftsregel: BR-21 Rechnungsposition
 */
public class LineID extends InlineRam {
	/** the included value **/ private final int value;

	/**
	 * neues Tag
	 * @param number einzusetzende Zeilennummer
	 */
	public LineID(int number) {
		super("LineID");
		value = number;
		content(""+number);
	}

	/**
	 * get the value of this field
	 * @return the line number
	 */
	public int value(){
		return value;
	}
}
