/* © SRSoftware 2025 */
package de.srsoftware.document.zugferd.tags.ram;

import de.srsoftware.document.zugferd.tags.base.Ram;
import de.srsoftware.document.zugferd.tags.udt.DateTimeString;
import java.time.LocalDate;

/**
 * Datentyp: udt:DateTimeType
 * Kardinalität: 1 .. 1
 * Anwendung: The date when the Invoice was issued.
 */
public class IssueDateTime extends Ram {

	/**
	 * neues Tag
	 * @param date einzusetzendes Datum
	 */
	public IssueDateTime(LocalDate date) {
		super("IssueDateTime");
		add(new DateTimeString(date));
	}
}
