/* © SRSoftware 2025 */
package de.srsoftware.document.zugferd.tags.ram;

import de.srsoftware.document.zugferd.data.Currency;
import de.srsoftware.document.zugferd.tags.base.InlineRam;

/**
 * Code für die Rechnungswährung
 * Datentyp: qdt:CurrencyCodeType
 * Hinweis: Die Rechnung ist in nur einer Währung auszustellen,
 *          ausgenommen hiervon ist nach Artikel 230 der Richtlinie 2006/112/EG [2]
 *          über Umsatzsteuer der Steuergesamtbetrag in Buchungswährung (BT-111).
 *          Die Listen der zugelassenen Währungen werden von der ISO 4217 Maintenance Agency
 *          „Codes for the representation of currencies and funds” geführt.
 * Kardinalität: 1 … 1
 * Anwendung: Die Währung, in der alle Rechnungsbeträge angegeben werden,
 *            ausgenommen ist der Steuergesamtbetrag in der Buchungswährung
 * Geschäftsregel: BR-5
 */
public class InvoiceCurrencyCode extends InlineRam {
	/**
	 * neues Tag
	 * @param currency einzusetzende Währung
	 */
	public InvoiceCurrencyCode(Currency currency) {
		super("InvoiceCurrencyCode");
		content(currency.toString());
	}
}
