/* © SRSoftware 2025 */
package de.srsoftware.document.zugferd.tags.ram;

import de.srsoftware.document.zugferd.data.LineItem;
import de.srsoftware.document.zugferd.tags.base.Ram;

/**
 * Datentyp: ram:SupplyChainTradeLineItemType
 * Synonym: Gruppierung von Positionsangaben
 * Kardinalität: 1 .. unbounded
 * Anwendung: Eine Gruppe von betriebswirtschaftlichen Begriffen, die Informationen über einzelne Rechnungspositionen enthält
 */
public class IncludedSupplyChainTradeLineItem extends Ram {
	/** documenz **/ private final AssociatedDocumentLineDocument associatedDocumentLineDocument;
	/** product **/  private final SpecifiedTradeProduct specifiedTradeProduct;

	/**
	 * neues Tag
	 * @param lineItem Daten zur Posiiton
	 */
	public IncludedSupplyChainTradeLineItem(LineItem lineItem) {
		super("IncludedSupplyChainTradeLineItem");
		add(associatedDocumentLineDocument = new AssociatedDocumentLineDocument(lineItem));
		add(specifiedTradeProduct = new SpecifiedTradeProduct(lineItem));
		add(new SpecifiedLineTradeAgreement(lineItem));
		add(new SpecifiedLineTradeDelivery(lineItem));
		add(new SpecifiedLineTradeSettlement(lineItem));
	}

	/**
	 * return the child tag AssociatedDocumentLineDocument
	 * @return the AssociatedDocumentLineDocument child tag
	 */
	public AssociatedDocumentLineDocument associatedDocumentLineDocument(){
		return associatedDocumentLineDocument;
	}

	/**
	 * return the child tag SpecifiedTradeProduct
	 * @return the SpecifiedTradeProduct child tag
	 */
	public SpecifiedTradeProduct specifiedTradeProduct(){
		return specifiedTradeProduct;
	}
}
